/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.ReadingStatePayload;
import de.maxanier.guideapi.wrapper.EntryWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CategoryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public HashMultimap<Integer, EntryWrapper> entryWrapperMap = HashMultimap.create();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int entryPage;
    @Nullable
    public EntryAbstract startEntry;

    public CategoryScreen(Book book, CategoryAbstract category, Player player, ItemStack bookStack, @Nullable EntryAbstract startEntry) {
        super(category.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.entryPage = 0;
        this.startEntry = startEntry;
    }

    public void init() {
        this.entryWrapperMap.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.minecraft.setScreen((Screen)new HomeScreen(this.book, this.player, this.bookStack)), this);
        this.addRenderableWidget((GuiEventListener)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.minecraft.setScreen((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.addRenderableWidget((GuiEventListener)this.buttonSearch);
        int eX = this.guiLeft + 37;
        int eY = this.guiTop + 15;
        int i = 0;
        int pageNumber = 0;
        ArrayList entries = Lists.newArrayList(this.category.entries.values());
        for (EntryAbstract entry : entries) {
            entry.onInit(this.book, this.category, this, this.player, this.bookStack);
            this.entryWrapperMap.put((Object)pageNumber, (Object)new EntryWrapper(this, this.book, this.category, entry, eX, eY, 4 * this.xSize / 6, 10, this.player, this.font, this.bookStack));
            if (entry.equals(this.startEntry)) {
                this.startEntry = null;
                this.entryPage = pageNumber;
            }
            eY += 13;
            if (++i < 11) continue;
            i = 0;
            eY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.minecraft.options.keyUse.getKey().getValue()) {
            this.minecraft.setScreen((Screen)new HomeScreen(this.book, this.player, this.bookStack));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.entryPage > 0) {
            this.prevPage();
            return true;
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int typeofClick) {
        boolean ret = super.mouseClicked(mouseX, mouseY, typeofClick);
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                wrapper.entry.onLeftClicked(this.book, this.category, mouseX, mouseY, this.player, this);
                continue;
            }
            if (typeofClick != 1) continue;
            wrapper.entry.onRightClicked(this.book, this.category, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.minecraft.setScreen((Screen)new HomeScreen(this.book, this.player, this.bookStack));
        }
        return ret;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0) {
            this.nextPage();
        } else if (pScrollY > 0.0) {
            this.prevPage();
        }
        return pScrollY != 0.0 || super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void nextPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty()) {
            ++this.entryPage;
        }
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.sendToServer((CustomPacketPayload)new ReadingStatePayload(this.entryPage, Optional.of(this.book.getCategoryList().indexOf(this.category)), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void prevPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != 0) {
            --this.entryPage;
        }
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.blit(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        super.render(graphics, mouseX, mouseY, renderPartialTicks);
        this.entryPage = Mth.clamp((int)this.entryPage, (int)0, (int)(this.entryWrapperMap.size() - 1));
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (wrapper.canPlayerSee()) {
                wrapper.draw(graphics, Minecraft.getInstance().level.registryAccess(), mouseX, mouseY, this);
                wrapper.drawExtras(graphics, mouseX, mouseY, this);
            }
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            wrapper.onHoverOver(mouseX, mouseY);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.font, String.format("%d/%d", this.entryPage + 1, this.entryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.drawCenteredString(this.font, this.category.getName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.entryPage != 0;
        this.buttonNext.visible = this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty();
    }
}

