/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl.abstraction;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class CategoryAbstract {
    public final Map<ResourceLocation, EntryAbstract> entries;
    public final Component name;
    private String keyBase;

    public CategoryAbstract(Map<ResourceLocation, EntryAbstract> entries, Component name) {
        this.entries = entries;
        this.name = name;
    }

    public CategoryAbstract(Component name) {
        this(Maps.newLinkedHashMap(), name);
    }

    public void addEntries(Map<ResourceLocation, EntryAbstract> entries) {
        this.entries.putAll(entries);
    }

    public void addEntry(ResourceLocation key, EntryAbstract entry) {
        this.entries.put(key, entry);
    }

    public void addEntry(String key, EntryAbstract entry) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + String.valueOf(this.name) + "' must be set.");
        }
        this.addEntry(ResourceLocation.fromNamespaceAndPath((String)this.keyBase, (String)key), entry);
    }

    public abstract boolean canSee(Player var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void draw(GuiGraphics var1, Book var2, int var3, int var4, int var5, int var6, int var7, int var8, BaseScreen var9, boolean var10);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawExtras(GuiGraphics var1, Book var2, int var3, int var4, int var5, int var6, int var7, int var8, BaseScreen var9, boolean var10);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryAbstract that = (CategoryAbstract)o;
        if (!Objects.equals(this.entries, that.entries)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public EntryAbstract getEntry(ResourceLocation key) {
        return this.entries.get(key);
    }

    public EntryAbstract getEntry(String key) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + this.name.getString() + "' must be set.");
        }
        return this.getEntry(ResourceLocation.fromNamespaceAndPath((String)this.keyBase, (String)key));
    }

    public Component getName() {
        return this.name;
    }

    public List<Component> getTooltip() {
        return Lists.newArrayList((Object[])new Component[]{this.getName()});
    }

    public int hashCode() {
        int result = this.entries != null ? this.entries.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onInit(Book var1, HomeScreen var2, Player var3, ItemStack var4);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onLeftClicked(Book var1, double var2, double var4, Player var6, ItemStack var7);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onRightClicked(Book var1, double var2, double var4, Player var6, ItemStack var7);

    public void removeEntries(List<ResourceLocation> keys) {
        for (ResourceLocation key : keys) {
            this.entries.remove(key);
        }
    }

    public void removeEntry(ResourceLocation key) {
        this.entries.remove(key);
    }

    public CategoryAbstract withKeyBase(String keyBase) {
        this.keyBase = keyBase;
        return this;
    }
}

