/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl;

import com.google.common.collect.Lists;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Entry
extends EntryAbstract {
    public Entry(List<IPage> pageList, Component name) {
        super(pageList, name);
    }

    public Entry(Component name) {
        super(name);
    }

    @Override
    public boolean canSee(Player player, ItemStack bookStack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, int entryX, int entryY, int entryWidth, int entryHeight, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        Component entryName = this.getName();
        int strWidth = fontRendererObj.width((FormattedText)entryName);
        int ellipsisWidth = fontRendererObj.width("...");
        if (strWidth > guiBase.xSize - 80 && strWidth > ellipsisWidth) {
            entryName = fontRendererObj.substrByWidth((FormattedText)entryName, guiBase.xSize - 80 - ellipsisWidth);
            entryName = FormattedText.composite((FormattedText[])new FormattedText[]{entryName, FormattedText.of((String)"...")});
        }
        FormattedCharSequence entryNameRe = Language.getInstance().getVisualOrder((FormattedText)entryName);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, entryWidth, entryHeight)) {
            graphics.drawString(fontRendererObj, entryNameRe, entryX + 12, entryY + 1, new Color(206, 206, 206).getRGB(), false);
            graphics.drawString(fontRendererObj, entryNameRe, entryX + 12, entryY, 4341436, false);
        } else {
            graphics.drawString(fontRendererObj, entryNameRe, entryX + 12, entryY, 0, false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, CategoryAbstract category, int entryX, int entryY, int entryWidth, int entryHeight, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        boolean cutString;
        int strWidth = fontRendererObj.width((FormattedText)this.getName());
        boolean bl = cutString = strWidth > guiBase.xSize - 80 && strWidth > fontRendererObj.width("...");
        if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, entryWidth, entryHeight) && cutString) {
            graphics.renderComponentTooltip(fontRendererObj, (List)Lists.newArrayList((Object[])new Component[]{this.getName()}), entryX, entryY + 12);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(Book book, CategoryAbstract category, CategoryScreen guiCategory, Player player, ItemStack bookStack) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onLeftClicked(Book book, CategoryAbstract category, double mouseX, double mouseY, Player player, CategoryScreen guiCategory) {
        Minecraft.getInstance().setScreen((Screen)new EntryScreen(book, category, this, player, guiCategory.bookStack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRightClicked(Book book, CategoryAbstract category, double mouseX, double mouseY, Player player, CategoryScreen guiCategory) {
    }
}

