/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl;

import com.google.common.base.Joiner;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.util.LogHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Book {
    private final List<CategoryAbstract> categories = new ArrayList<CategoryAbstract>();
    private final Consumer<List<CategoryAbstract>> contentProvider;
    private final Component title;
    private final Component header;
    private final Component itemName;
    private final Component author;
    private final ResourceLocation pageTexture;
    private final ResourceLocation outlineTexture;
    private final Color color;
    private final boolean spawnWithBook;
    private final ResourceLocation registryName;
    private boolean isInitialized;

    protected Book(Consumer<List<CategoryAbstract>> contentProvider, Component title, Component header, Component displayName, Component author, ResourceLocation pageTexture, ResourceLocation outlineTexture, Color color, boolean spawnWithBook, ResourceLocation registryName) {
        this.contentProvider = contentProvider;
        this.title = title;
        this.header = header;
        this.itemName = displayName;
        this.author = author;
        this.pageTexture = pageTexture;
        this.outlineTexture = outlineTexture;
        this.color = color;
        this.spawnWithBook = spawnWithBook;
        this.registryName = registryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        return this.getRegistryName().equals((Object)book.getRegistryName());
    }

    public void forceInitializeContent() {
        LogHelper.info("Force initializing book content " + this.registryName.toString());
        this.categories.clear();
        this.isInitialized = false;
        this.initializeContent();
    }

    public Component getAuthor() {
        return this.author;
    }

    public List<CategoryAbstract> getCategoryList() {
        return this.categories;
    }

    public Color getColor() {
        return this.color;
    }

    public Component getHeader() {
        return this.header;
    }

    public Component getItemName() {
        return this.itemName;
    }

    public ResourceLocation getOutlineTexture() {
        return this.outlineTexture;
    }

    public ResourceLocation getPageTexture() {
        return this.pageTexture;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Component getTitle() {
        return this.title;
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public void initializeContent() {
        if (!this.isInitialized) {
            LogHelper.debug("Opening book " + this.registryName.toString() + " for the first time -> Initializing content");
            this.contentProvider.accept(this.categories);
            for (CategoryAbstract category : this.categories) {
                for (Map.Entry<ResourceLocation, EntryAbstract> resourceLocationEntryAbstractEntry : category.entries.entrySet()) {
                    if (!resourceLocationEntryAbstractEntry.getValue().pageList.isEmpty()) continue;
                    throw new IllegalStateException("Empty entry " + resourceLocationEntryAbstractEntry.getKey().toString() + " in category " + category.name.getString() + " in book " + this.registryName.toString());
                }
            }
            this.isInitialized = true;
        }
    }

    public boolean shouldSpawnWithBook() {
        return this.spawnWithBook;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("categoryList", (Object)Joiner.on((String)", ").join(this.categories)).append("title", (Object)this.title).append("header", (Object)this.header).append("itemName", (Object)this.itemName).append("author", (Object)this.author).append("pageTexture", (Object)this.pageTexture).append("outlineTexture", (Object)this.outlineTexture).append("color", (Object)this.color).append("spawnWithBook", this.spawnWithBook).append("registryName", (Object)this.registryName).toString();
    }
}

