/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.util.AnnotationHandler;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(value={Dist.CLIENT}, modid="guideapi_vp", bus=EventBusSubscriber.Bus.MOD)
public class RegistrarGuideAPIClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            event.register(new ModelResourceLocation(loc, "standalone"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void bakeModel(ModelEvent.ModifyBakingResult event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            ModelResourceLocation newMrl = new ModelResourceLocation(loc, "standalone");
            Item bookItem = GuideAPI.getStackFromBook((Book)guide.getLeft()).getItem();
            ModelResourceLocation oldMrl = new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)bookItem), "inventory");
            BakedModel model = (BakedModel)event.getModels().get(newMrl);
            event.getModels().put(oldMrl, model);
        }
    }
}

