/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.VampireBookLootProvider;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.component.VampireBookContents;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class AddBookNbtFunction
extends LootItemConditionalFunction {
    public static final MapCodec<AddBookNbtFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> AddBookNbtFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AddBookNbtFunction::new));

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder() {
        return AddBookNbtFunction.simpleBuilder(AddBookNbtFunction::new);
    }

    AddBookNbtFunction(@NotNull List<LootItemCondition> conditions) {
        super(conditions);
    }

    @NotNull
    public LootItemFunctionType<AddBookNbtFunction> getType() {
        return (LootItemFunctionType)ModLoot.ADD_BOOK_NBT.get();
    }

    @NotNull
    public ItemStack run(@NotNull ItemStack itemStack, @NotNull LootContext lootContext) {
        Entity victim = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        Optional<String> id = Optional.empty();
        if (victim instanceof VampireBookLootProvider) {
            VampireBookLootProvider provider = (VampireBookLootProvider)victim;
            id = provider.getBookLootId();
        }
        VampireBookManager.BookContext bookContext = id.map(VampireBookManager.getInstance()::getBookContextById).orElseGet(() -> VampireBookManager.getInstance().getRandomBook(lootContext.getRandom()));
        VampireBookContents.addFromBook(itemStack, bookContext);
        return itemStack;
    }
}

