/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.util.OilUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.stream.Collector;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SmeltItemLootModifier
extends LootModifier {
    public static final MapCodec<SmeltItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> SmeltItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltItemLootModifier::new));

    public SmeltItemLootModifier(LootItemCondition ... conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ItemStack stack = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof LivingEntity) || stack == null || OilUtils.getAppliedOil(stack).filter(oil -> oil == ModOils.SMELT.get()).isEmpty()) {
            return generatedLoot;
        }
        stack = ((LivingEntity)entity).getMainHandItem();
        OilUtils.reduceAppliedOilDuration(stack);
        return this.trySmelting(generatedLoot, context.getLevel());
    }

    private ObjectArrayList<ItemStack> trySmelting(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull ServerLevel level) {
        RecipeManager recipeManager = level.getRecipeManager();
        return generatedLoot.stream().map(stack -> recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level).map(recipe -> ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).filter(result -> !result.isEmpty()).orElse((ItemStack)stack)).collect(Collector.of(ObjectArrayList::new, ObjectArrayList::add, (left, right) -> {
            left.addAll((ObjectList)right);
            return left;
        }, new Collector.Characteristics[0]));
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

