/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.vampirehut;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.core.ModStructures;
import de.teamlapen.vampirism.world.gen.structure.vampirehut.VampireHutPieces;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;

public class VampireHutStructure
extends Structure {
    public static final MapCodec<VampireHutStructure> CODEC = VampireHutStructure.simpleCodec(VampireHutStructure::new);

    public VampireHutStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext pContext) {
        return VampireHutStructure.onTopOfChunkCenter((Structure.GenerationContext)pContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, pContext));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        ChunkPos chunk = context.chunkPos();
        WorldgenRandom random = context.random();
        VampireHutPieces.addPieces(context.structureTemplateManager(), (StructurePieceAccessor)builder, (RandomSource)random, new BlockPos(chunk.getMinBlockX(), 90, chunk.getMinBlockZ()));
    }

    @NotNull
    public StructureType<?> type() {
        return (StructureType)ModStructures.VAMPIRE_HUT_TYPE.get();
    }
}

