/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.feature;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.blocks.DarkStoneBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModLootTables;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.MonsterRoomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VampireDungeonFeature
extends MonsterRoomFeature {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();

    public VampireDungeonFeature(@NotNull Codec<NoneFeatureConfiguration> featureConfig) {
        super(featureConfig);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> p_160066_) {
        Predicate predicate = Feature.isReplaceable((TagKey)BlockTags.FEATURES_CANNOT_REPLACE);
        BlockPos blockpos = p_160066_.origin();
        RandomSource randomsource = p_160066_.random();
        WorldGenLevel worldgenlevel = p_160066_.level();
        int i = 3;
        int j = randomsource.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int i1 = -1;
        int j1 = 4;
        int k1 = randomsource.nextInt(2) + 2;
        int l1 = -k1 - 1;
        int i2 = k1 + 1;
        int j2 = 0;
        for (int k2 = k; k2 <= l; ++k2) {
            for (int l2 = -1; l2 <= 4; ++l2) {
                for (int i3 = l1; i3 <= i2; ++i3) {
                    BlockPos blockpos1 = blockpos.offset(k2, l2, i3);
                    boolean flag = worldgenlevel.getBlockState(blockpos1).isSolid();
                    if (l2 == -1 && !flag) {
                        return false;
                    }
                    if (l2 == 4 && !flag) {
                        return false;
                    }
                    if (k2 != k && k2 != l && i3 != l1 && i3 != i2 || l2 != 0 || !worldgenlevel.isEmptyBlock(blockpos1) || !worldgenlevel.isEmptyBlock(blockpos1.above())) continue;
                    ++j2;
                }
            }
        }
        if (j2 >= 1 && j2 <= 5) {
            for (int k3 = k; k3 <= l; ++k3) {
                for (int i4 = 3; i4 >= -1; --i4) {
                    for (int k4 = l1; k4 <= i2; ++k4) {
                        BlockPos blockpos2 = blockpos.offset(k3, i4, k4);
                        BlockState blockstate = worldgenlevel.getBlockState(blockpos2);
                        if (k3 != k && i4 != -1 && k4 != l1 && k3 != l && i4 != 4 && k4 != i2) {
                            if (blockstate.is(Blocks.CHEST) || blockstate.is(Blocks.SPAWNER)) continue;
                            this.safeSetBlock(worldgenlevel, blockpos2, CAVE_AIR, predicate);
                            continue;
                        }
                        if (blockpos2.getY() >= worldgenlevel.getMinBuildHeight() && !worldgenlevel.getBlockState(blockpos2.below()).isSolid()) {
                            worldgenlevel.setBlock(blockpos2, CAVE_AIR, 2);
                            continue;
                        }
                        if (!blockstate.isSolid() || blockstate.is(Blocks.CHEST)) continue;
                        if (i4 == -1 && randomsource.nextInt(4) != 0) {
                            this.safeSetBlock(worldgenlevel, blockpos2, (p_160066_.random().nextInt(20) == 0 ? (DarkStoneBlock)((Object)ModBlocks.BLOODY_DARK_STONE_BRICKS.get()) : (DarkStoneBlock)((Object)ModBlocks.DARK_STONE_BRICKS.get())).defaultBlockState(), predicate);
                            continue;
                        }
                        this.safeSetBlock(worldgenlevel, blockpos2, Blocks.SPRUCE_PLANKS.defaultBlockState(), predicate);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int j5;
                    int i5;
                    int l4 = blockpos.getX() + randomsource.nextInt(j * 2 + 1) - j;
                    BlockPos blockpos3 = new BlockPos(l4, i5 = blockpos.getY(), j5 = blockpos.getZ() + randomsource.nextInt(k1 * 2 + 1) - k1);
                    if (!worldgenlevel.isEmptyBlock(blockpos3)) continue;
                    int j3 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!worldgenlevel.getBlockState(blockpos3.relative(direction)).isSolid()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    this.safeSetBlock(worldgenlevel, blockpos3, StructurePiece.reorient((BlockGetter)worldgenlevel, (BlockPos)blockpos3, (BlockState)Blocks.CHEST.defaultBlockState()), predicate);
                    RandomizableContainer.setBlockEntityLootTable((BlockGetter)worldgenlevel, (RandomSource)randomsource, (BlockPos)blockpos3, ModLootTables.CHEST_VAMPIRE_DUNGEON);
                    continue block6;
                }
            }
            this.safeSetBlock(worldgenlevel, blockpos, Blocks.SPAWNER.defaultBlockState(), predicate);
            BlockEntity blockentity = worldgenlevel.getBlockEntity(blockpos);
            if (blockentity instanceof SpawnerBlockEntity) {
                ((SpawnerBlockEntity)blockentity).getSpawner().setEntityId((EntityType)ModEntities.VAMPIRE.get(), null, randomsource, blockpos);
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)blockpos.getX(), (Object)blockpos.getY(), (Object)blockpos.getZ());
            }
            return true;
        }
        return false;
    }
}

