/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampireBookItem;
import de.teamlapen.vampirism.items.component.VampireBookContents;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VampireBookManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static VampireBookManager instance;
    private final Map<String, BookContext> idToBook = new HashMap<String, BookContext>();
    private final List<BookContext> nonUnique = new ArrayList<BookContext>();
    private final BookContext DUMMY = new BookContext(new BookInfo("Unknown", "Unknown", "Failed to load"), "error", false, new String[0]);
    private final BookContext OLD = new BookContext(new BookInfo("Unknown", "Unknown", "\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630"), "old", false, new String[0]);
    public static final String OLD_ID = "old";

    @NotNull
    public static VampireBookManager getInstance() {
        if (instance == null) {
            instance = new VampireBookManager();
        }
        return instance;
    }

    private VampireBookManager() {
    }

    public BookInfo getBookById(String id) {
        return this.idToBook.getOrDefault((Object)id, (BookContext)this.DUMMY).book;
    }

    public BookContext getBookContextById(String id) {
        return this.idToBook.getOrDefault(id, this.DUMMY);
    }

    public BookContext getRandomBook(@NotNull RandomSource rng) {
        return !this.nonUnique.isEmpty() ? this.nonUnique.get(rng.nextInt(this.nonUnique.size())) : this.DUMMY;
    }

    @NotNull
    public ItemStack getRandomBookItem(@NotNull RandomSource rng) {
        ItemStack book = new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get(), 1);
        VampireBookContents.addFromBook(book, this.getRandomBook(rng));
        return book;
    }

    @NotNull
    public Collection<ItemStack> getAllBookItems() {
        return this.idToBook.values().stream().filter(s -> s != this.DUMMY && s != this.OLD).map(context -> ((VampireBookItem)ModItems.VAMPIRE_BOOK.get()).contentInstance((BookContext)context)).toList();
    }

    public void init() {
        block15: {
            try (InputStream inputStream = VampirismMod.class.getResourceAsStream("/vampireBooks.json");){
                if (inputStream == null) {
                    throw new IOException("Could not find 'vampireBooks.json' in resources");
                }
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    ArrayList books = Lists.newArrayList((Iterable)((Iterable)BookContext.CODEC.listOf().parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).getOrThrow()));
                    this.idToBook.clear();
                    this.idToBook.put(OLD_ID, this.OLD);
                    for (BookContext b : books) {
                        this.idToBook.put(b.id, b);
                        if (b.unique) continue;
                        this.nonUnique.add(b);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("----------------------------------------");
                LOGGER.error("Failed to load vampire books from JSON", (Throwable)e);
                LOGGER.warn("----------------------------------------");
                if (!VampirismMod.inDev) break block15;
                throw new RuntimeException(e);
            }
        }
    }

    public record BookContext(BookInfo book, String id, boolean unique, String[] tags) {
        public static final Codec<BookContext> CODEC = RecordCodecBuilder.create(item -> item.group((App)BookInfo.CODEC.fieldOf("book").forGetter(bookContext -> bookContext.book), (App)Codec.STRING.fieldOf("id").forGetter(bookContext -> bookContext.id), (App)Codec.BOOL.fieldOf("unique").orElse((Object)false).forGetter(bookContext -> bookContext.unique), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(bookContext -> Arrays.asList(bookContext.tags))).apply((Applicative)item, BookContext::new));

        public BookContext(BookInfo book, String id, Boolean unique, @NotNull List<String> tags) {
            this(book, id, (boolean)unique, tags.toArray(new String[0]));
        }
    }

    public record BookInfo(String title, String author, String[] content) {
        public static final Codec<BookInfo> CODEC = RecordCodecBuilder.create(item -> item.group((App)Codec.STRING.fieldOf("title").forGetter(bookInfo -> bookInfo.title), (App)Codec.STRING.fieldOf("author").forGetter(bookInfo -> bookInfo.author), (App)Codec.STRING.listOf().fieldOf("content").forGetter(bookInfo -> Arrays.asList(bookInfo.content))).apply((Applicative)item, BookInfo::new));

        public BookInfo(String title, String author, @NotNull List<String> content) {
            this(title, author, content.toArray(new String[0]));
        }
    }
}

