/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class RegUtil {
    public static ResourceLocation id(@NotNull IAction<?> action) {
        return ModRegistries.ACTIONS.getKey(action);
    }

    public static ResourceLocation id(@NotNull ISkill<?> skill) {
        return ModRegistries.SKILLS.getKey(skill);
    }

    public static ResourceLocation id(@NotNull IMinionTask<?, ?> minionTask) {
        return ModRegistries.MINION_TASKS.getKey(minionTask);
    }

    public static ResourceLocation id(@NotNull IEntityAction entityAction) {
        return ModRegistries.ENTITY_ACTIONS.getKey((Object)entityAction);
    }

    public static ResourceLocation id(@NotNull IRefinement refinement) {
        return ModRegistries.REFINEMENTS.getKey((Object)refinement);
    }

    public static ResourceLocation id(@NotNull IRefinementSet refinementSet) {
        return ModRegistries.REFINEMENT_SETS.getKey((Object)refinementSet);
    }

    public static ResourceLocation id(@NotNull Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation id(@NotNull Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation id(@NotNull Fluid block) {
        return BuiltInRegistries.FLUID.getKey((Object)block);
    }

    public static ResourceLocation id(@NotNull EntityType<?> type) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(type);
    }

    public static ResourceLocation id(Level level, @NotNull Biome type) {
        return level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)type);
    }

    public static ResourceLocation id(@NotNull VillagerProfession profession) {
        return BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
    }

    public static ResourceLocation id(@NotNull IOil oil) {
        return ModRegistries.OILS.getKey((Object)oil);
    }

    public static ResourceLocation id(@NotNull Level level, ISkillTree tree) {
        return level.registryAccess().registryOrThrow(VampirismRegistries.Keys.SKILL_TREE).getKey((Object)tree);
    }

    public static Optional<ResourceKey<IAction<?>>> key(@NotNull IAction<?> action) {
        return ModRegistries.ACTIONS.getResourceKey(action);
    }

    public static boolean has(@NotNull IAction<?> action) {
        return ModRegistries.ACTIONS.containsValue(action);
    }

    public static boolean has(@NotNull ISkill<?> skill) {
        return ModRegistries.SKILLS.containsValue(skill);
    }

    public static boolean has(@NotNull IMinionTask<?, ?> minionTask) {
        return ModRegistries.MINION_TASKS.containsValue(minionTask);
    }

    public static boolean has(@NotNull IEntityAction entityAction) {
        return ModRegistries.ENTITY_ACTIONS.containsValue((Object)entityAction);
    }

    public static boolean has(@NotNull IRefinement refinement) {
        return ModRegistries.REFINEMENTS.containsValue((Object)refinement);
    }

    public static boolean has(@NotNull IRefinementSet refinementSet) {
        return ModRegistries.REFINEMENT_SETS.containsValue((Object)refinementSet);
    }

    public static boolean has(@NotNull Item item) {
        return BuiltInRegistries.ITEM.containsValue((Object)item);
    }

    public static boolean has(@NotNull Block block) {
        return BuiltInRegistries.BLOCK.containsValue((Object)block);
    }

    public static boolean has(@NotNull ServerLevel level, @NotNull Biome biome) {
        return level.registryAccess().registryOrThrow(Registries.BIOME).containsValue((Object)biome);
    }

    public static IAction<?> getAction(@NotNull ResourceLocation id) {
        return (IAction)ModRegistries.ACTIONS.get(id);
    }

    public static ISkill<?> getSkill(@NotNull ResourceLocation id) {
        return (ISkill)ModRegistries.SKILLS.get(id);
    }

    public static Biome getBiome(ServerLevel level, @NotNull ResourceLocation id) {
        return (Biome)level.registryAccess().registryOrThrow(Registries.BIOME).get(id);
    }

    public static IMinionTask<?, ?> getMinionTask(@NotNull ResourceLocation id) {
        return (IMinionTask)ModRegistries.MINION_TASKS.get(id);
    }

    public static IEntityAction getEntityAction(@NotNull ResourceLocation id) {
        return (IEntityAction)ModRegistries.ENTITY_ACTIONS.get(id);
    }

    public static IRefinement getRefinement(@NotNull ResourceLocation id) {
        return (IRefinement)ModRegistries.REFINEMENTS.get(id);
    }

    public static IRefinementSet getRefinementSet(@NotNull ResourceLocation id) {
        return (IRefinementSet)ModRegistries.REFINEMENT_SETS.get(id);
    }

    public static IOil getOil(@NotNull ResourceLocation id) {
        return (IOil)ModRegistries.OILS.get(id);
    }

    public static <T, Z extends Registry<T>> Holder<T> getHolder(Level level, ResourceKey<Z> registry, T type) {
        return level.registryAccess().registryOrThrow(registry).wrapAsHolder(type);
    }

    public static Holder<DamageType> getHolder(Level level, DamageType type) {
        return RegUtil.getHolder(level, Registries.DAMAGE_TYPE, type);
    }

    public static <T> boolean has(@NotNull Registry<T> registry, @NotNull ResourceLocation id) {
        return registry.containsKey(id);
    }

    @NotNull
    public static <T> Collection<T> values(@NotNull Registry<T> registry) {
        return registry.stream().toList();
    }

    public static Holder<ISkillTree> getSkillTree(Level level, String asString) {
        return level.registryAccess().registryOrThrow(VampirismRegistries.Keys.SKILL_TREE).getHolderOrThrow(ResourceKey.create(VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)ResourceLocation.parse((String)asString)));
    }
}

