/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.mojang.authlib.GameProfile;
import de.teamlapen.vampirism.util.PlayerModelType;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class PlayerSkinHelper {
    public static void obtainPlayerSkinPropertiesAsync(GameProfile input, @NotNull Consumer<Pair<ResourceLocation, PlayerModelType>> callback) {
        Minecraft.getInstance().getSkinManager().getOrLoad(input).thenAccept(skin -> callback.accept(Pair.of((Object)skin.texture(), (Object)((Object)PlayerSkinHelper.fromVanilla(skin.model())))));
    }

    public static PlayerSkin.Model toVanilla(PlayerModelType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlayerModelType.WIDE -> PlayerSkin.Model.WIDE;
            case PlayerModelType.SLIM -> PlayerSkin.Model.SLIM;
        };
    }

    public static PlayerModelType fromVanilla(PlayerSkin.Model type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlayerSkin.Model.WIDE -> PlayerModelType.WIDE;
            case PlayerSkin.Model.SLIM -> PlayerModelType.SLIM;
        };
    }
}

