/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.LevelDamage;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageHandler {
    public static void affectVampireGarlicSplash(@NotNull IVampire vampire, @NotNull EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(@NotNull IVampire vampire, @NotNull EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(@NotNull IVampire vampire, @NotNull EnumStrength strength, float multiplier, boolean ambient) {
        if (strength == EnumStrength.NONE) {
            return;
        }
        LivingEntity entity = vampire.asEntity();
        entity.addEffect(new MobEffectInstance(ModEffects.GARLIC, (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof Player && ((Player)entity).getAbilities().instabuild) {
            return;
        }
        entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer) {
            IActionHandler<IVampirePlayer> actionHandler = ((IVampirePlayer)vampire).getActionHandler();
            actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
        }
    }

    public static void affectVampireGarlicAmbient(@NotNull IVampire vampire, @NotNull EnumStrength strength, int ticks) {
        if (ticks % 17 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(@NotNull LivingEntity entity, @NotNull EnumStrength strength, double distSq, boolean directHit) {
        DamageHandler.affectEntityHolyWaterSplash(entity, strength, distSq, directHit, null);
    }

    public static void affectEntityHolyWaterSplash(@NotNull LivingEntity entity, @NotNull EnumStrength strength, double distSq, boolean directHit, @Nullable LivingEntity source) {
        IActionHandlerEntity h;
        if (!entity.isAlive()) {
            return;
        }
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.isAffectedByPotions() && (vampire || entity.getType().is(EntityTypeTags.UNDEAD)) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            if (entity instanceof Player) {
                int l = VampirismPlayerAttributes.get((Player)((Player)entity)).vampireLevel;
                amount = DamageHandler.scaleDamageWithLevel(l, 14, amount * 0.8, amount * 1.3);
            } else if (entity instanceof VampireBaronEntity) {
                int l = ((VampireBaronEntity)entity).getEntityLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 4, amount * 0.8, amount * 2.0);
            }
            DamageHandler.hurtModded((Entity)entity, ModDamageSources::holyWater, (float)amount);
        }
        if (vampire && entity instanceof Player) {
            Player player = (Player)entity;
            IActionHandler<IVampirePlayer> actionHandler = VampirePlayer.get(player).getActionHandler();
            actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
            actionHandler.deactivateAction((ILastingAction)VampireActions.VAMPIRE_INVISIBILITY.get());
        } else if (vampire && entity instanceof IEntityActionUser && (h = ((IEntityActionUser)entity).getActionHandler()).isActionActive((IEntityAction)EntityActions.ENTITY_INVISIBLE.get())) {
            h.deactivateAction();
        }
        if (vampire) {
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }

    public static double scaleDamageWithLevel(int level, int maxLevel, double minDamage, double maxDamage) {
        return minDamage + (double)level / (double)maxLevel * (maxDamage - minDamage);
    }

    @NotNull
    public static Optional<DamageSource> getDamageSource(@NotNull Level world, @NotNull Function<ModDamageSources, DamageSource> sourceFunc) {
        return LevelDamage.getOpt(world).map(sourceFunc);
    }

    public static boolean hurtModded(@NotNull Entity entity, @NotNull Function<ModDamageSources, DamageSource> sourceFunc, float amount) {
        return DamageHandler.getDamageSource(entity.level(), sourceFunc).map(source -> entity.hurt(source, amount)).orElse(false);
    }

    public static boolean hurtVanilla(@NotNull Entity entity, @NotNull Function<DamageSources, DamageSource> sourceFunc, float amount) {
        DamageSource source = sourceFunc.apply(entity.level().damageSources());
        return entity.hurt(source, amount);
    }

    public static boolean kill(@NotNull Entity entity, int damage) {
        return DamageHandler.hurtVanilla(entity, DamageSources::generic, damage);
    }
}

