/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.util.ItemDataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class ExtendedBrewingRecipeRegistry
implements IExtendedBrewingRecipeRegistry {
    private final List<ExtendedPotionMix> conversionMixes = new ArrayList<ExtendedPotionMix>();

    @Override
    public void addMix(ExtendedPotionMix potionMix) {
        this.conversionMixes.add(potionMix);
    }

    @Override
    public void addMix(ExtendedPotionMix[] mixPredicate) {
        this.conversionMixes.addAll(Arrays.asList(mixPredicate));
    }

    @Override
    public boolean brewPotions(Level level, @NotNull NonNullList<ItemStack> inputs, @NotNull ItemStack ingredient, @NotNull ItemStack extraIngredient, @NotNull IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int @NotNull [] inputIndexes, boolean onlyExtended) {
        boolean brewed = false;
        int useMain = 0;
        int useExtra = 0;
        for (int i : inputIndexes) {
            Optional<Triple<ItemStack, Integer, Integer>> output = this.getOutput(level, (ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities, onlyExtended);
            if (!output.isPresent()) continue;
            Triple<ItemStack, Integer, Integer> triple = output.get();
            inputs.set(i, (Object)((ItemStack)triple.getLeft()));
            useMain = Math.max(useMain, (Integer)triple.getMiddle());
            useExtra = Math.max(useExtra, (Integer)triple.getRight());
            brewed = true;
        }
        ingredient.shrink(useMain);
        extraIngredient.shrink(useExtra);
        return brewed;
    }

    @Override
    public boolean canBrew(Level level, @NotNull NonNullList<ItemStack> inputs, @NotNull ItemStack ingredient, @NotNull ItemStack extraIngredient, @NotNull IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int @NotNull [] inputIndexes) {
        if (ingredient.isEmpty()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!this.hasOutput(level, (ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Optional<Triple<ItemStack, Integer, Integer>> getOutput(Level level, @NotNull ItemStack bottle, @NotNull ItemStack ingredient, @NotNull ItemStack extraIngredient, @NotNull IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, boolean onlyExtended) {
        if (bottle.isEmpty() || bottle.getCount() != 1) {
            return Optional.empty();
        }
        if (ingredient.isEmpty()) {
            return Optional.empty();
        }
        PotionContents potion = (PotionContents)bottle.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (bottle.getItem() instanceof ThrowablePotionItem && StreamSupport.stream(potion.getAllEffects().spliterator(), false).anyMatch(a -> ((MobEffect)a.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL)) {
            return Optional.empty();
        }
        Item item = bottle.getItem();
        ArrayList<ExtendedPotionMix> possibleResults = new ArrayList<ExtendedPotionMix>();
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!potion.is(mix.input) || !mix.reagent1.get().test(ingredient) || ingredient.getCount() < mix.reagent1Count || mix.reagent2Count > 0 && (!mix.reagent2.get().test(extraIngredient) || extraIngredient.getCount() < mix.reagent2Count) || !mix.canBrew(capabilities)) continue;
            possibleResults.add(mix);
        }
        if (!possibleResults.isEmpty()) {
            possibleResults.sort((mix1, mix2) -> mix1.efficient ? (mix2.efficient ? 0 : -1) : (mix2.efficient ? 1 : 0));
            ExtendedPotionMix mix = (ExtendedPotionMix)possibleResults.getFirst();
            return Optional.of(Triple.of((Object)ItemDataUtils.setPotion(new ItemStack((ItemLike)item), mix.output), (Object)mix.reagent1Count, (Object)mix.reagent2Count));
        }
        ItemStack output = level.potionBrewing().mix(ingredient, bottle);
        return output.isEmpty() ? Optional.empty() : Optional.of(Triple.of((Object)output, (Object)1, (Object)0));
    }

    @Override
    @NotNull
    public List<ExtendedPotionMix> getPotionMixes() {
        return Collections.unmodifiableList(this.conversionMixes);
    }

    @Override
    public boolean hasOutput(Level level, @NotNull ItemStack input, @NotNull ItemStack ingredient, @NotNull ItemStack extraIngredient, @NotNull IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities) {
        return this.getOutput(level, input, ingredient, extraIngredient, capabilities, false).isPresent();
    }

    @Override
    public boolean isValidExtraIngredient(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent2.get().test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidIngredient(PotionBrewing registry, @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent1.get().test(stack)) continue;
            return true;
        }
        return registry.isIngredient(stack);
    }

    @Override
    public boolean isValidInput(PotionBrewing registry, @NotNull ItemStack stack) {
        if (stack.getCount() != 1) {
            return false;
        }
        Item item = stack.getItem();
        return item == Items.POTION || item == Items.SPLASH_POTION || item == Items.LINGERING_POTION || item == Items.GLASS_BOTTLE || registry.isInput(stack);
    }
}

