/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IOilItem;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.items.component.AppliedOilContent;
import de.teamlapen.vampirism.items.component.OilContent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ApplicableOilRecipe
extends CustomRecipe {
    public ApplicableOilRecipe(@NotNull CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inventory, @NotNull Level world) {
        IApplicableOil oil = null;
        ItemStack tool = null;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof IOilItem) {
                IApplicableOil applicableOil;
                if (oil != null) {
                    return false;
                }
                Holder<IOil> oil1 = ((IOilItem)stack.getItem()).getOil(stack);
                Object object = oil1.value();
                if (!(object instanceof IApplicableOil)) continue;
                oil = applicableOil = (IApplicableOil)object;
                continue;
            }
            if (tool != null) {
                return false;
            }
            tool = stack;
        }
        return oil != null && tool != null && (!(tool.getItem() instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)tool.getItem()).getExclusiveFaction(tool) == VReference.HUNTER_FACTION) && oil.canBeApplied(tool);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inventory, @NotNull HolderLookup.Provider registryAccess) {
        ItemStack oilStack = ItemStack.EMPTY;
        ItemStack toolStack = ItemStack.EMPTY;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof IOilItem) {
                oilStack = stack;
                continue;
            }
            toolStack = stack;
        }
        ItemStack result = toolStack.copy();
        if (oilStack.isEmpty() || toolStack.isEmpty()) {
            return result;
        }
        Holder<IOil> oil = OilContent.getOil(oilStack);
        if (oil.value() instanceof IApplicableOil) {
            AppliedOilContent.apply(result, oil);
        }
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.APPLICABLE_OIL.get();
    }
}

