/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import com.mojang.authlib.GameProfile;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.FogDiffuserBlockEntity;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.client.gui.screens.DBNOScreen;
import de.teamlapen.vampirism.client.gui.screens.FogDiffuserScreen;
import de.teamlapen.vampirism.client.gui.screens.GarlicDiffuserScreen;
import de.teamlapen.vampirism.client.gui.screens.HunterMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.screens.HunterMinionStatsScreen;
import de.teamlapen.vampirism.client.gui.screens.NameSwordScreen;
import de.teamlapen.vampirism.client.gui.screens.RevertBackScreen;
import de.teamlapen.vampirism.client.gui.screens.VampireMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.screens.VampireMinionStatsScreen;
import de.teamlapen.vampirism.client.renderer.blockentity.ModBlockEntityItemRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.proxy.CommonProxy;
import de.teamlapen.vampirism.util.PlayerModelType;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends CommonProxy {
    private Map<UUID, ResourceKey<SoundEvent>> bossEventSounds = new HashMap<UUID, ResourceKey<SoundEvent>>();
    private ModBlockEntityItemRenderer blockEntityItemRenderer;

    @Override
    public void displayGarlicBeaconScreen(GarlicDiffuserBlockEntity tile, Component title) {
        ClientProxy.openScreen(new GarlicDiffuserScreen(tile, title));
    }

    @Override
    public void displayFogDiffuserScreen(FogDiffuserBlockEntity tile, Component title) {
        ClientProxy.openScreen(new FogDiffuserScreen(tile, title));
    }

    @Override
    public void displayNameSwordScreen(ItemStack stack) {
        ClientProxy.openScreen(new NameSwordScreen(stack));
    }

    @Override
    public void displayRevertBackScreen() {
        ClientProxy.openScreen((Screen)new RevertBackScreen());
    }

    @Override
    public void displayVampireMinionAppearanceScreen(VampireMinionEntity entity) {
        ClientProxy.openScreen(new VampireMinionAppearanceScreen(entity, Minecraft.getInstance().screen));
    }

    @Override
    public void displayVampireMinionStatsaScreen(VampireMinionEntity entity) {
        ClientProxy.openScreen(new VampireMinionStatsScreen(entity, Minecraft.getInstance().screen));
    }

    @Override
    public void displayHunterMinionAppearanceScreen(HunterMinionEntity entity) {
        ClientProxy.openScreen(new HunterMinionAppearanceScreen(entity, Minecraft.getInstance().screen));
    }

    @Override
    public void displayHunterMinionStatsScreen(HunterMinionEntity entity) {
        ClientProxy.openScreen(new HunterMinionStatsScreen(entity, Minecraft.getInstance().screen));
    }

    @Override
    public void obtainPlayerSkins(GameProfile profile, @NotNull Consumer<Pair<ResourceLocation, PlayerModelType>> callback) {
        PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(profile, callback);
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    @Nullable
    public Entity getMouseOverEntity() {
        HitResult r = Minecraft.getInstance().hitResult;
        if (r instanceof EntityHitResult) {
            return ((EntityHitResult)r).getEntity();
        }
        return null;
    }

    @Override
    public void handleSleepClient(@NotNull Player player) {
        if (player.isSleeping()) {
            player.getSleepingPos().ifPresent(pos -> {
                if (player.level().getBlockState(pos).getBlock() instanceof TentBlock) {
                    TentBlock.setTentSleepPosition(player, pos, (Integer)player.level().getBlockState(pos).getValue((Property)TentBlock.POSITION), (Direction)player.level().getBlockState(pos).getValue((Property)TentBlock.FACING));
                } else if (player.level().getBlockState(pos).getBlock() instanceof CoffinBlock) {
                    CoffinBlock.setCoffinSleepPosition(player, pos, player.level().getBlockState(pos));
                }
            });
        }
    }

    @Override
    public void showDBNOScreen(@NotNull Player playerEntity, @Nullable Component deathMessage) {
        if (playerEntity == Minecraft.getInstance().player && !playerEntity.isDeadOrDying()) {
            ClientProxy.openScreen(new DBNOScreen(deathMessage));
        }
    }

    @Override
    public void sendToServer(CustomPacketPayload packetPayload) {
        Minecraft.getInstance().getConnection().send(packetPayload);
    }

    @Override
    public void spawnParticles(Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (!(world instanceof ClientLevel)) {
            return;
        }
        VoxelShape voxelshape = state.getShape((BlockGetter)world, pos);
        voxelshape.forAllBoxes((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
            double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
            double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
            double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
            int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
            for (int l = 0; l < i / 2; ++l) {
                for (int i1 = 0; i1 < j / 2; ++i1) {
                    for (int j1 = 0; j1 < k / 2; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_199284_3_;
                        double d8 = d5 * d2 + p_199284_5_;
                        double d9 = d6 * d3 + p_199284_7_;
                        Minecraft.getInstance().particleEngine.add((Particle)new TerrainParticle((ClientLevel)world, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state));
                    }
                }
            }
        });
    }

    public static void runOnRenderThread(Runnable runnable) {
        Minecraft.getInstance().execute(runnable);
    }

    public static void openScreen(Screen screen) {
        ClientProxy.runOnRenderThread(() -> Minecraft.getInstance().setScreen(screen));
    }

    public static ClientProxy get() {
        return (ClientProxy)VampirismMod.proxy;
    }

    public ModBlockEntityItemRenderer getBlockEntityItemRenderer() {
        return this.blockEntityItemRenderer;
    }

    @Override
    public void addBossEventSound(UUID bossEventUuid, ResourceKey<SoundEvent> sound) {
        this.bossEventSounds.put(bossEventUuid, sound);
    }

    public ResourceKey<SoundEvent> getBossEventSound(UUID bossEventUuid) {
        return this.bossEventSounds.get(bossEventUuid);
    }

    public void registerBlockEntityItemRenderer() {
        this.blockEntityItemRenderer = new ModBlockEntityItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }
}

