/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.util.ByteBufferCodecUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record ClientboundRequestMinionSelectPacket(Action action, List<Pair<Integer, Component>> minions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundRequestMinionSelectPacket> TYPE = new CustomPacketPayload.Type(VResourceLocation.mod("request_minion_select"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundRequestMinionSelectPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(Action::valueOf, Enum::name), ClientboundRequestMinionSelectPacket::action, (StreamCodec)ByteBufferCodecUtil.pair(ByteBufCodecs.VAR_INT, ComponentSerialization.STREAM_CODEC).apply(ByteBufCodecs.collection(i -> new ArrayList())), ClientboundRequestMinionSelectPacket::minions, ClientboundRequestMinionSelectPacket::new);

    @NotNull
    public static Optional<ClientboundRequestMinionSelectPacket> createRequestForPlayer(@NotNull ServerPlayer player, Action action) {
        FactionPlayerHandler fp = FactionPlayerHandler.get((Player)player);
        PlayerMinionController controller = MinionWorldData.getData(player.server).getOrCreateController(fp);
        Collection<Integer> ids = controller.getCallableMinions();
        if (!ids.isEmpty()) {
            ArrayList<Pair<Integer, Component>> minions = new ArrayList<Pair<Integer, Component>>(ids.size());
            ids.forEach(id -> controller.contactMinionData((int)id, data -> data.getFormattedName().copy()).ifPresent(n -> minions.add(Pair.of((Object)id, (Object)n))));
            return Optional.of(new ClientboundRequestMinionSelectPacket(action, minions));
        }
        ServerboundSelectMinionTaskPacket.printRecoveringMinions(player, controller.getRecoveringMinionNames());
        return Optional.empty();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Action {
        CALL;

    }
}

