/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.gui.screens.AlchemicalCauldronScreen;
import de.teamlapen.vampirism.client.gui.screens.AlchemyTableScreen;
import de.teamlapen.vampirism.client.gui.screens.PotionTableScreen;
import de.teamlapen.vampirism.client.gui.screens.WeaponTableScreen;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.TaskUtil;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronMenu;
import de.teamlapen.vampirism.inventory.WeaponTableMenu;
import de.teamlapen.vampirism.items.BlessableItem;
import de.teamlapen.vampirism.items.component.AppliedOilContent;
import de.teamlapen.vampirism.items.component.BottleBlood;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.modcompat.jei.AlchemicalCauldronRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.AlchemyTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.BlessingRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.PotionTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.TaskRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.WeaponTableRecipeCategory;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.recipes.AlchemyTableRecipe;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class VampirismJEIPlugin
implements IModPlugin {
    public static final RecipeType<RecipeHolder<IWeaponTableRecipe>> WEAPON_TABLE = VampirismJEIPlugin.createFromModded(ModRecipes.WEAPONTABLE_CRAFTING_TYPE);
    public static final RecipeType<RecipeHolder<AlchemicalCauldronRecipe>> ALCHEMICAL_CAULDRON = VampirismJEIPlugin.createFromModded(ModRecipes.ALCHEMICAL_CAULDRON_TYPE);
    public static final RecipeType<Task> TASK = RecipeType.create((String)"vampirism", (String)"task", Task.class);
    public static final RecipeType<BlessableItem.Recipe> BLESSING = RecipeType.create((String)"vampirism", (String)"blessing", BlessableItem.Recipe.class);
    public static final RecipeType<JEIPotionMix> POTION = RecipeType.create((String)"vampirism", (String)"potion", JEIPotionMix.class);
    public static final RecipeType<RecipeHolder<AlchemyTableRecipe>> ALCHEMY_TABLE = VampirismJEIPlugin.createFromModded(ModRecipes.ALCHEMICAL_TABLE_TYPE);
    private static final ResourceLocation ID = VResourceLocation.mod("plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public static <R extends Recipe<?>> RecipeType<RecipeHolder<R>> createFromModded(DeferredHolder<net.minecraft.world.item.crafting.RecipeType<?>, net.minecraft.world.item.crafting.RecipeType<R>> vanillaRecipeType) {
        Class<RecipeHolder> holderClass = RecipeHolder.class;
        return new RecipeType(vanillaRecipeType.getId(), holderClass);
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemicalCauldronRecipeCategory(helper), new WeaponTableRecipeCategory(helper), new TaskRecipeCategory(helper), new PotionTableRecipeCategory(helper), new AlchemyTableRecipeCategory(helper), new BlessingRecipeCategory(helper)});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlchemicalCauldronScreen.class, 80, 34, 20, 15, new RecipeType[]{ALCHEMICAL_CAULDRON});
        registration.addRecipeClickArea(WeaponTableScreen.class, 114, 46, 20, 15, new RecipeType[]{WEAPON_TABLE});
        registration.addRecipeClickArea(PotionTableScreen.class, 145, 17, 9, 28, new RecipeType[]{POTION});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 73, 57, 28, 8, new RecipeType[]{ALCHEMY_TABLE});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 104, 36, 32, 32, new RecipeType[]{ALCHEMY_TABLE});
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlchemicalCauldronMenu.class, (MenuType)ModMenus.ALCHEMICAL_CAULDRON.get(), ALCHEMICAL_CAULDRON, 0, 2, 4, 36);
        registration.addRecipeTransferHandler(AlchemicalCauldronMenu.class, (MenuType)ModMenus.ALCHEMICAL_CAULDRON.get(), RecipeTypes.FUELING, 3, 1, 4, 36);
        registration.addRecipeTransferHandler(WeaponTableMenu.class, (MenuType)ModMenus.WEAPON_TABLE.get(), WEAPON_TABLE, 1, 16, 17, 36);
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.OIL_BOTTLE.get(), (IIngredientSubtypeInterpreter)OilNBT.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ModItems.BLOOD_BOTTLE.get(), (IIngredientSubtypeInterpreter)BloodNBT.INSTANCE);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.getInstance().level;
        RecipeManager recipeManager = world.getRecipeManager();
        registration.addRecipes(ALCHEMICAL_CAULDRON, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get()));
        registration.addRecipes(WEAPON_TABLE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get()));
        registration.addRecipes(TASK, TaskUtil.getItemRewardTasks(world.registryAccess()));
        registration.addRecipes(POTION, VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().map(JEIPotionMix::createFromMix).flatMap(Collection::stream).collect(Collectors.toList()));
        registration.addRecipes(RecipeTypes.ANVIL, this.getRepairRecipes(registration.getVanillaRecipeFactory()));
        registration.addRecipes(ALCHEMY_TABLE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()));
        registration.addRecipes(RecipeTypes.CRAFTING, this.getApplicableOilRecipes());
        registration.addRecipes(BLESSING, BlessableItem.getBlessableRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, this.getCleanOilRecipes(world.registryAccess()));
    }

    public void registerVanillaCategoryExtensions(@NotNull IVanillaCategoryExtensionRegistration registration) {
    }

    @NotNull
    private List<IJeiAnvilRecipe> getRepairRecipes(@NotNull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        HashMap items = Maps.newHashMap();
        Ingredient ironIngredient = Tiers.IRON.getRepairIngredient();
        items.put(ironIngredient, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HUNTER_AXE_NORMAL.get(), (Item)ModItems.HUNTER_AXE_ENHANCED.get(), (Item)ModItems.HUNTER_AXE_ULTIMATE.get(), (Item)ModItems.BASIC_TECH_CROSSBOW.get(), (Item)ModItems.ENHANCED_TECH_CROSSBOW.get(), (Item)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), (Item)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), (Item)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), (Item)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_FEET_NORMAL.get(), (Item)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_FEET_ULTIMATE.get()}));
        Ingredient stringIngredient = Ingredient.of((TagKey)Tags.Items.STRINGS);
        items.put(stringIngredient, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.BASIC_CROSSBOW.get(), (Item)ModItems.BASIC_DOUBLE_CROSSBOW.get(), (Item)ModItems.ENHANCED_CROSSBOW.get(), (Item)ModItems.ENHANCED_DOUBLE_CROSSBOW.get()}));
        Ingredient leather = Ingredient.of((TagKey)Tags.Items.LEATHERS);
        items.put(leather, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get()}));
        Ingredient bloodIngot = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_IRON_INGOT.get()});
        items.put(bloodIngot, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HEART_SEEKER_NORMAL.get(), (Item)ModItems.HEART_STRIKER_NORMAL.get()}));
        Ingredient enhancedBloodIngot = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()});
        items.put(enhancedBloodIngot, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HEART_SEEKER_ENHANCED.get(), (Item)ModItems.HEART_SEEKER_ULTIMATE.get(), (Item)ModItems.HEART_STRIKER_ENHANCED.get(), (Item)ModItems.HEART_STRIKER_ULTIMATE.get()}));
        Ingredient human_heart = Ingredient.of(ModTags.Items.HEART);
        items.put(human_heart, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.VAMPIRE_CLOTHING_CROWN.get(), (Item)ModItems.VAMPIRE_CLOTHING_HAT.get(), (Item)ModItems.VAMPIRE_CLOTHING_LEGS.get(), (Item)ModItems.VAMPIRE_CLOTHING_BOOTS.get(), (Item)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_RED.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get(), (Item)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).getItems());
            for (Item ingredientItem : (List)entry.getValue()) {
                ItemStack ingredient = new ItemStack((ItemLike)ingredientItem);
                ItemStack damaged1 = ingredient.copy();
                damaged1.setDamageValue(damaged1.getMaxDamage());
                ItemStack damaged2 = ingredient.copy();
                damaged2.setDamageValue(damaged2.getMaxDamage() * 3 / 4);
                ItemStack damaged3 = ingredient.copy();
                damaged3.setDamageValue(damaged3.getMaxDamage() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    IJeiAnvilRecipe repairWithMaterial = factory.createAnvilRecipe(damaged1, (List)repairMaterials, Collections.singletonList(damaged2));
                    recipes.add(repairWithMaterial);
                }
                IJeiAnvilRecipe repairWithSame = factory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithSame);
            }
        }
        return recipes;
    }

    @NotNull
    private List<RecipeHolder<CraftingRecipe>> getApplicableOilRecipes() {
        return ModRegistries.OILS.holders().filter(s -> s.value() instanceof IApplicableOil).map(s -> (Holder)s).flatMap(oil -> BuiltInRegistries.ITEM.stream().map(Item::getDefaultInstance).filter(item -> !(item.getItem() instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)item.getItem()).getExclusiveFaction((ItemStack)item) == VReference.HUNTER_FACTION).filter(item -> ((IApplicableOil)oil.value()).canBeApplied((ItemStack)item)).map(stack -> new RecipeHolder(VResourceLocation.mod((((ResourceKey)oil.unwrapKey().orElseThrow()).location().toString() + String.valueOf(RegUtil.id(stack.getItem()))).replace(':', '_')), (Recipe)new ShapelessRecipe("", CraftingBookCategory.EQUIPMENT, AppliedOilContent.apply(stack.copy(), (Holder<IApplicableOil>)oil), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{stack}), Ingredient.of((ItemStack[])new ItemStack[]{OilContent.createItemStack((Item)ModItems.OIL_BOTTLE.get(), (Holder<? extends IOil>)oil)})}))))).toList();
    }

    @NotNull
    private List<RecipeHolder<CraftingRecipe>> getCleanOilRecipes(RegistryAccess registryAccess) {
        return this.getApplicableOilRecipes().stream().map(recipe -> {
            ItemStack item = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
            IApplicableOil oil = OilUtils.getAppliedOil(item).get();
            return new RecipeHolder(VResourceLocation.mod(("clean_" + String.valueOf(RegUtil.id(oil)) + "_from_" + String.valueOf(RegUtil.id(item.getItem()))).replace(':', '_')), (Recipe)new ShapelessRecipe("", CraftingBookCategory.EQUIPMENT, AppliedOilContent.remove(item.copy()), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemStack[])new ItemStack[]{item})})));
        }).collect(Collectors.toList());
    }

    private static class OilNBT
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final OilNBT INSTANCE = new OilNBT();

        private OilNBT() {
        }

        @NotNull
        public String apply(@NotNull ItemStack itemStack, @NotNull UidContext context) {
            return Optional.ofNullable((OilContent)itemStack.get(ModDataComponents.OIL)).map(OilContent::oil).flatMap(Holder::unwrapKey).map(ResourceKey::location).map(ResourceLocation::toString).orElse("");
        }
    }

    private static class BloodNBT
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final BloodNBT INSTANCE = new BloodNBT();

        private BloodNBT() {
        }

        @NotNull
        public String apply(@NotNull ItemStack itemStack, @NotNull UidContext context) {
            return Optional.ofNullable((BottleBlood)itemStack.get(ModDataComponents.BOTTLE_BLOOD)).map(BottleBlood::blood).map(Object::toString).orElse("");
        }
    }
}

