/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageItemStack;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class PageTaskItemStack
extends PageItemStack {
    private boolean setup = false;
    @NotNull
    private final ResourceKey<Task> taskKey;

    public PageTaskItemStack(@NotNull ResourceKey<Task> task) {
        super((FormattedText)Component.empty(), ItemStack.EMPTY);
        this.taskKey = task;
    }

    private void setupTask(RegistryAccess access) {
        access.registry(VampirismRegistries.Keys.TASK).flatMap(registry -> registry.getHolder(this.taskKey)).ifPresent(holder -> {
            Task task = (Task)holder.value();
            this.ingredient = Ingredient.of(((ItemReward)task.getReward()).getAllPossibleRewards().stream());
            ArrayList<Object> text = new ArrayList<Object>();
            MutableComponent newLine = Component.literal((String)"\n");
            if (holder.is(ModTags.Tasks.HAS_FACTION)) {
                text.add(Component.translatable((String)"text.vampirism.task.reward_obtain_for", (Object[])new Object[]{String.join((CharSequence)", ", Arrays.stream(VampirismAPI.factionRegistry().getFactions()).filter(x -> x.getTag(VampirismRegistries.Keys.TASK).filter(arg_0 -> ((Holder.Reference)holder).is(arg_0)).isPresent()).map(IFaction::getNamePlural).map(Component::getString).toList()) + " "}));
            } else {
                text.add(Component.translatable((String)"text.vampirism.task.reward_obtain_all"));
            }
            text.add(newLine);
            text.add(newLine);
            text.add(task.getTitle());
            text.add(newLine);
            text.add(Component.translatable((String)"text.vampirism.task.prerequisites"));
            text.add(newLine);
            TaskUnlocker[] unlockers = task.getUnlocker();
            if (unlockers.length > 0) {
                for (TaskUnlocker u : unlockers) {
                    text.add(Component.literal((String)"- ").append(u.getDescription()).append((Component)newLine));
                }
            } else {
                text.add(Component.translatable((String)"text.vampirism.task.prerequisites.none"));
            }
            this.draw = FormattedText.composite(text);
            this.setup = true;
        });
    }

    public void draw(GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        if (!this.setup) {
            this.setupTask(registryAccess);
        }
        super.draw(guiGraphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof PageTaskItemStack)) return false;
        PageTaskItemStack other = (PageTaskItemStack)((Object)o);
        if (!Objects.equals(other.taskKey, this.taskKey)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.taskKey.hashCode();
    }
}

