/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class PageTable
extends Page {
    private final List<Component[]> lines;
    private final int[] width;
    private final MutableComponent headline;

    private PageTable(List<Component[]> lines, int[] width, MutableComponent headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(@NotNull GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen guiBase, @NotNull Font font) {
        float charWidth = font.width("W");
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            guiGraphics.drawString(font, (Component)this.headline.withStyle(ChatFormatting.BOLD), x, y, 0, false);
            Objects.requireNonNull(font);
            y += 9;
        }
        double d = x;
        Objects.requireNonNull(font);
        double d2 = y + 9;
        double d3 = (float)x + (float)guiBase.xSize * 3.0f / 5.0f;
        Objects.requireNonNull(font);
        this.drawLine(guiGraphics, d, d2, d3, y + 9, 0.0f);
        for (Component[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = (int)((float)this.width[i] * charWidth);
                int aw = font.width((FormattedText)l[i]);
                int dw = (mw - aw) / 2;
                guiGraphics.drawString(font, l[i], x + dw, y, 0, false);
                x += mw;
            }
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    protected void drawLine(@NotNull GuiGraphics guiGraphics, double x1, double y1, double x2, double y2, float publicZLevel) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        Matrix4f matrix = pose.last().pose();
        GL11.glDisable((int)3553);
        RenderSystem.lineWidth((float)2.0f);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex((float)x1, (float)y1, publicZLevel).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)x2, (float)y2, publicZLevel).setColor(0, 0, 0, 255);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        GL11.glEnable((int)3553);
        pose.popPose();
    }

    public static class Builder {
        int columns;
        List<Component[]> lines;
        MutableComponent headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<Component[]>();
        }

        @NotNull
        public Builder addLine(Component ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            this.lines.add(objects);
            return this;
        }

        @NotNull
        public Builder addLine(Object ... objects) {
            return this.addLine((Component[])Arrays.stream(objects).map(object -> {
                if (object instanceof Component) {
                    Component comp = (Component)object;
                    return comp;
                }
                return Component.literal((String)String.valueOf(object));
            }).toArray(Component[]::new));
        }

        @NotNull
        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (Component[] s : this.lines) {
                    int w = s[i].getString().length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }

        @NotNull
        public Builder setHeadline(MutableComponent s) {
            this.headline = s;
            return this;
        }
    }
}

