/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.items.component.SelectedAmmunition;
import de.teamlapen.vampirism.util.ModEnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismCrossbowItem
extends CrossbowItem
implements IFactionLevelItem<IHunterPlayer>,
IVampirismCrossbow {
    protected final Tier itemTier;
    protected final float arrowVelocity;
    protected final int chargeTime;

    public VampirismCrossbowItem(Item.Properties properties, float arrowVelocity, int chargeTime, Tier itemTier) {
        super(properties);
        this.arrowVelocity = arrowVelocity;
        this.chargeTime = chargeTime;
        this.itemTier = itemTier;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        this.addAmmunitionTypeHoverText(stack, context, tooltips, flag);
        this.addFactionToolTips(stack, context, tooltips, flag, VampirismMod.proxy.getClientPlayer());
    }

    protected void addAmmunitionTypeHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        this.getAmmunition(stack).ifPresent(ammunition -> tooltips.add((Component)Component.translatable((String)"text.vampirism.crossbow.ammo_type").append(" ").append(ammunition.getName(stack)).withStyle(ChatFormatting.GRAY)));
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles(@NotNull ItemStack stack) {
        return this.getSupportedProjectiles(stack);
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles(@NotNull ItemStack stack) {
        return this.getSupportedProjectiles(stack);
    }

    public boolean isValidRepairItem(@NotNull ItemStack crossbow, ItemStack repairItem) {
        return repairItem.is(Tags.Items.STRINGS) || super.isValidRepairItem(crossbow, repairItem);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.itemTier.getEnchantmentValue();
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public int getUseDuration(ItemStack pStack, LivingEntity entity) {
        return this.getChargeDurationMod(pStack, entity.level()) + 3;
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, float speed, float angle, @Nullable LivingEntity p_331602_) {
        if (level instanceof ServerLevel) {
            ChargedProjectiles chargedprojectiles;
            ServerLevel serverLevel = (ServerLevel)level;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                if (EventHooks.onArrowLoose((ItemStack)crossbow, (Level)shooter.level(), (Player)player, (int)1, (boolean)true) < 0) {
                    return;
                }
            }
            if (!(chargedprojectiles = (ChargedProjectiles)crossbow.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).isEmpty()) {
                ArrayList<ItemStack> availableProjectiles = new ArrayList<ItemStack>(chargedprojectiles.getItems());
                List<ItemStack> arrows = this.getShootingProjectiles(serverLevel, crossbow, availableProjectiles);
                this.shoot(serverLevel, shooter, hand, crossbow, arrows, speed, angle, shooter instanceof Player, p_331602_);
                this.onShoot(shooter, crossbow);
                crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(availableProjectiles));
            }
        }
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, List<ItemStack> projectiles, float speed, float inaccuracy, boolean isPlayer, @Nullable LivingEntity p_331167_) {
        for (int i = 0; i < projectiles.size(); ++i) {
            ItemStack itemstack = projectiles.get(i);
            if (itemstack.isEmpty()) continue;
            crossbowStack.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            Projectile projectile = this.createProjectile((Level)level, shooter, crossbowStack, itemstack, isPlayer);
            if (crossbowStack.remove(ModDataComponents.CROSSBOW_FRUGALITY_TRIGGERED) != null && projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            this.shootProjectile(shooter, projectile, i, speed, inaccuracy, 0.0f, p_331167_);
            level.addFreshEntity((Entity)projectile);
        }
    }

    protected List<ItemStack> getShootingProjectiles(ServerLevel serverLevel, ItemStack crossbow, List<ItemStack> availableProjectiles) {
        List<ItemStack> shootingProjectiles = List.copyOf(availableProjectiles);
        if (ModEnchantmentHelper.processFrugality(serverLevel, crossbow)) {
            crossbow.set(ModDataComponents.CROSSBOW_FRUGALITY_TRIGGERED, (Object)Unit.INSTANCE);
        } else {
            availableProjectiles.clear();
        }
        return shootingProjectiles;
    }

    protected void onShoot(LivingEntity shooter, ItemStack crossbow) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)shooter;
            CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, crossbow);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)crossbow.getItem()));
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weapon) {
        if (this.ignoreHurtTimer(projectileStack) && arrow instanceof IEntityCrossbowArrow) {
            ((IEntityCrossbowArrow)arrow).setIgnoreHurtTimer();
        }
        return arrow;
    }

    protected boolean ignoreHurtTimer(ItemStack crossbow) {
        return false;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int usedDuration) {
        int i = this.getUseDuration(stack, entity) - usedDuration;
        float f = this.getPowerForTimeMod(i, stack, level);
        if (f >= 1.0f && !VampirismCrossbowItem.isCharged((ItemStack)stack) && this.tryLoadProjectiles(entity, stack)) {
            SoundSource soundcategory = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CROSSBOW_LOADING_END, soundcategory, 1.0f, 1.0f / (level.random.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getPowerForTimeMod(int p_220031_0_, ItemStack p_220031_1_, Level level) {
        float f = (float)p_220031_0_ / (float)this.getChargeDurationMod(p_220031_1_, level);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getChargeDurationMod(ItemStack crossbow, Level level) {
        Registry enchantments = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        int i = crossbow.getEnchantmentLevel((Holder)enchantments.getHolderOrThrow(Enchantments.QUICK_CHARGE));
        return i == 0 ? this.chargeTime : this.chargeTime - 2 * i;
    }

    protected boolean tryLoadProjectiles(LivingEntity pShooter, ItemStack pCrossbowStack) {
        List<ItemStack> list = this.drawMod(pCrossbowStack, pShooter.getProjectile(pCrossbowStack), pShooter);
        if (!list.isEmpty()) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(((ChargedProjectiles)pCrossbowStack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).getItems());
            itemStacks.addAll(list);
            pCrossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(itemStacks));
            return true;
        }
        return false;
    }

    protected List<ItemStack> getLoadingProjectiles(ItemStack crossbowStack, ItemStack projectileStack, LivingEntity shooter) {
        Item item = projectileStack.getItem();
        if (item instanceof IArrowContainer) {
            IArrowContainer container = (IArrowContainer)item;
            return container.getAndRemoveArrows(projectileStack).stream().toList();
        }
        return List.of(projectileStack);
    }

    protected List<ItemStack> drawMod(ItemStack crossbowStack, ItemStack projectileStack, LivingEntity shooter) {
        if (projectileStack.isEmpty()) {
            return List.of();
        }
        return this.getLoadingProjectiles(crossbowStack, projectileStack, shooter).stream().map(projectile -> VampirismCrossbowItem.useAmmo(crossbowStack, projectile, shooter, false)).toList();
    }

    protected static ItemStack useAmmo(ItemStack crossbowStack, ItemStack projectileStack, LivingEntity shooter, boolean infinite) {
        boolean flag;
        boolean bl = flag = !infinite && !shooter.hasInfiniteMaterials() && (!(projectileStack.getItem() instanceof ArrowItem) || !((ArrowItem)projectileStack.getItem()).isInfinite(projectileStack, crossbowStack, shooter));
        if (!flag) {
            ItemStack itemstack1 = projectileStack.copyWithCount(1);
            itemstack1.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            return itemstack1;
        }
        ItemStack itemstack = projectileStack.split(1);
        if (projectileStack.isEmpty() && shooter instanceof Player) {
            Player player = (Player)shooter;
            player.getInventory().removeItem(projectileStack);
        }
        return itemstack;
    }

    @Override
    public boolean canSelectAmmunition(ItemStack crossbow) {
        return true;
    }

    @Override
    public Optional<Item> getAmmunition(ItemStack crossbow) {
        return Optional.ofNullable((SelectedAmmunition)crossbow.get(ModDataComponents.SELECTED_AMMUNITION)).map(SelectedAmmunition::item);
    }

    @Override
    public void setAmmunition(ItemStack crossbow, @Nullable Item ammo) {
        if (ammo == null) {
            crossbow.remove(ModDataComponents.SELECTED_AMMUNITION);
        } else {
            crossbow.set(ModDataComponents.SELECTED_AMMUNITION, (Object)new SelectedAmmunition(ammo));
        }
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    @Override
    public Predicate<ItemStack> getSupportedProjectiles(ItemStack crossbow) {
        return this.getAllSupportedProjectiles().and(stack -> {
            if (this.canSelectAmmunition(crossbow)) {
                return this.getAmmunition(crossbow).map(restriction -> stack.getItem() == restriction).orElse(true);
            }
            return true;
        });
    }
}

