/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.vampire.VampireLeveling;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PureBloodItem
extends Item {
    public static final int COUNT = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private final int level;
    private String descriptionId;

    @NotNull
    public static PureBloodItem getBloodItemForLevel(int level) {
        return switch (level) {
            case 0 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_0.get());
            case 1 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_1.get());
            case 2 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_2.get());
            case 3 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_3.get());
            case 4 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_4.get());
            default -> {
                LOGGER.warn("Pure blood of level {} does not exist", (Object)level);
                yield (PureBloodItem)((Object)ModItems.PURE_BLOOD_4.get());
            }
        };
    }

    public PureBloodItem(int level) {
        super(new Item.Properties());
        this.level = level;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.vampirism.pure_blood.purity").append((Component)Component.literal((String)(": " + (this.level + 1) + "/5"))).withStyle(ChatFormatting.RED));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            VampirePlayer vampire = VampirePlayer.get(player);
            vampire.drinkBlood(50, 0.4f + 0.15f * (float)this.getLevel(), false, new DrinkBloodContext(stack));
            entityLiving.addEffect(new MobEffectInstance(ModEffects.SATURATION));
            stack.shrink(1);
        }
        return stack;
    }

    public int getLevel() {
        return this.level;
    }

    @NotNull
    public Component getCustomName() {
        return Component.translatable((String)this.getOrCreateDescriptionId()).append((Component)Component.literal((String)(" " + (this.level + 1))));
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 30;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        int playerLevel = VampirismAPI.factionPlayerHandler(playerIn).getCurrentLevel(VReference.VAMPIRE_FACTION);
        if (VampireLeveling.getInfusionRequirement(playerLevel).filter(x -> x.pureBloodLevel() < this.getLevel()).isPresent()) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.sidedSuccess((Object)playerIn.getItemInHand(handIn), (boolean)worldIn.isClientSide);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @NotNull
    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = super.getOrCreateDescriptionId().replaceAll("_\\d", "");
        }
        return this.descriptionId;
    }
}

