/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HolyWaterBottleItem
extends Item
implements IItemWithTier,
IFactionExclusiveItem {
    private final IItemWithTier.TIER tier;
    private String descriptionId;

    public HolyWaterBottleItem(IItemWithTier.TIER tier) {
        this(tier, new Item.Properties());
    }

    protected HolyWaterBottleItem(IItemWithTier.TIER tier, @NotNull Item.Properties props) {
        super(props);
        this.tier = tier;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @NotNull
    public EnumStrength getStrength(@NotNull IItemWithTier.TIER tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> EnumStrength.WEAK;
            case IItemWithTier.TIER.ENHANCED -> EnumStrength.MEDIUM;
            case IItemWithTier.TIER.ULTIMATE -> EnumStrength.STRONG;
        };
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @NotNull
    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = super.getOrCreateDescriptionId().replaceAll("_normal|_enhanced|_ultimate", "");
        }
        return this.descriptionId;
    }
}

