/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampireSwordItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeartStrikerItem
extends VampireSwordItem
implements IItemWithTier {
    public static final VampireSwordItem.VampireSwordMaterial NORMAL = new VampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.NORMAL, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 500, -4.1f, 2.2f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_IRON_INGOT.get()}), 1.25f);
    public static final VampireSwordItem.VampireSwordMaterial ENHANCED = new VampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.ENHANCED, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1750, -4.0f, 4.2f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()}), 1.3f);
    public static final VampireSwordItem.VampireSwordMaterial ULTIMATE = new VampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.ULTIMATE, (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2500, -3.9f, 6.2f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()}), 1.35f);
    @NotNull
    private final IItemWithTier.TIER tier;

    public HeartStrikerItem(@NotNull VampireSwordItem.VampireSwordMaterial material) {
        super(material, 3, new Item.Properties());
        this.tier = material.getTier();
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.getVampirismTier() == IItemWithTier.TIER.ULTIMATE ? super.getXpRepairRatio(stack) / 2.0f : super.getXpRepairRatio(stack);
    }

    @Override
    protected float getChargeUsage() {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordBloodUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }
}

