/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.TaskManager;
import de.teamlapen.vampirism.inventory.TaskMenu;
import de.teamlapen.vampirism.network.ServerboundTaskActionPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismMenu
extends InventoryContainerMenu
implements TaskMenu {
    private static final Function<Player, InventoryContainerMenu.SelectorInfo[]> SELECTOR_INFOS = player -> {
        IFaction faction = FactionPlayerHandler.getCurrentFactionPlayer(player).orElseThrow(() -> new IllegalStateException("Opening vampirism container without faction")).getFaction();
        return new InventoryContainerMenu.SelectorInfo[]{new InventoryContainerMenu.SelectorInfo(arg_0 -> VampirismMenu.lambda$static$1((IPlayableFaction)faction, arg_0), 58, 8), new InventoryContainerMenu.SelectorInfo(arg_0 -> VampirismMenu.lambda$static$2((IPlayableFaction)faction, arg_0), 58, 26), new InventoryContainerMenu.SelectorInfo(arg_0 -> VampirismMenu.lambda$static$3((IPlayableFaction)faction, arg_0), 58, 44)};
    };
    private final IFactionPlayer<?> factionPlayer;
    private final TextColor factionColor;
    private final NonNullList<ItemStack> refinementStacks;
    @NotNull
    public Map<UUID, TaskManager.TaskWrapper> taskWrapper = new HashMap<UUID, TaskManager.TaskWrapper>();
    @NotNull
    public Map<UUID, Set<UUID>> completableTasks = new HashMap<UUID, Set<UUID>>();
    @NotNull
    public Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements = new HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>>();
    @Nullable
    private Runnable listener;
    private final boolean refinementsAvailable;
    private final Registry<Task> registry;

    public VampirismMenu(int id, @NotNull Inventory playerInventory) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModMenus.VAMPIRISM.get()), id, playerInventory, ContainerLevelAccess.NULL, (Container)new SimpleContainer(3), RemovingSelectorSlot::new, SELECTOR_INFOS.apply(playerInventory.player));
        this.factionPlayer = FactionPlayerHandler.get(playerInventory.player).getCurrentFactionPlayer().orElseThrow(() -> new IllegalStateException("Opening vampirism container without faction"));
        this.factionColor = this.factionPlayer.getFaction().getChatColor();
        this.refinementsAvailable = this.factionPlayer.getFaction().hasRefinements();
        this.addPlayerSlots(playerInventory, 37, 124);
        this.refinementStacks = this.factionPlayer.getSkillHandler().getRefinementItems();
        this.registry = playerInventory.player.level().registryAccess().registryOrThrow(VampirismRegistries.Keys.TASK);
    }

    @Override
    public Registry<Task> getRegistry() {
        return this.registry;
    }

    @Override
    public boolean areRequirementsCompleted(@NotNull ITaskInstance taskInfo, @NotNull TaskRequirement.Type type) {
        if (this.completedRequirements.containsKey(taskInfo.getTaskBoard()) && this.completedRequirements.get(taskInfo.getTaskBoard()).containsKey(taskInfo.getId())) {
            Map<ResourceLocation, Integer> data = this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId());
            for (TaskRequirement.Requirement<?> requirement : this.getTask(taskInfo.getTask()).getRequirement().requirements().get((Object)type)) {
                if (data.containsKey(requirement.id()) && data.get(requirement.id()) >= requirement.getAmount(this.factionPlayer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TaskMenu.TaskAction buttonAction(@NotNull ITaskInstance taskInfo) {
        return taskInfo.isUnique(this.registry) || this.factionPlayer.asEntity().level().getGameTime() < taskInfo.getTaskTimeStamp() ? TaskMenu.TaskAction.ABORT : TaskMenu.TaskAction.REMOVE;
    }

    @Override
    public boolean canCompleteTask(@NotNull ITaskInstance taskInfo) {
        return this.completableTasks.containsKey(taskInfo.getTaskBoard()) && this.completableTasks.get(taskInfo.getTaskBoard()).contains(taskInfo.getId()) && (taskInfo.isUnique(this.registry) || this.factionPlayer.asEntity().level().getGameTime() < taskInfo.getTaskTimeStamp());
    }

    @Override
    public TextColor getFactionColor() {
        return this.factionColor;
    }

    public NonNullList<ItemStack> getRefinementStacks() {
        return this.refinementStacks;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return this.refinementsAvailable;
    }

    public boolean areRefinementsAvailable() {
        return this.refinementsAvailable;
    }

    @Override
    public int getRequirementStatus(@NotNull ITaskInstance taskInfo, @NotNull TaskRequirement.Requirement<?> requirement) {
        assert (this.completedRequirements != null);
        if (this.completedRequirements.containsKey(taskInfo.getTaskBoard())) {
            return this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId()).get(requirement.id());
        }
        return requirement.getAmount(this.factionPlayer);
    }

    @NotNull
    public Collection<ITaskInstance> getTaskInfos() {
        return this.taskWrapper.values().stream().flatMap(t -> t.getTaskInstances().stream().filter(ITaskInstance::isAccepted)).collect(Collectors.toList());
    }

    public void init(@NotNull Map<UUID, TaskManager.TaskWrapper> taskWrapper, @NotNull Map<UUID, Set<UUID>> completableTasks, @NotNull Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements) {
        this.taskWrapper = taskWrapper;
        this.completedRequirements = completedRequirements;
        this.completableTasks = completableTasks;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public boolean isCompleted(@NotNull ITaskInstance item) {
        return false;
    }

    @Override
    public boolean isRequirementCompleted(@NotNull ITaskInstance taskInfo, @NotNull TaskRequirement.Requirement<?> requirement) {
        if (this.completedRequirements != null && this.completedRequirements.containsKey(taskInfo.getTaskBoard()) && this.completedRequirements.get(taskInfo.getTaskBoard()).containsKey(taskInfo.getId())) {
            Map<ResourceLocation, Integer> data = this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId());
            return data.containsKey(requirement.id()) && data.get(requirement.id()) >= requirement.getAmount(this.factionPlayer);
        }
        return false;
    }

    @Override
    public boolean isTaskNotAccepted(@NotNull ITaskInstance taskInfo) {
        return false;
    }

    @Override
    public void pressButton(@NotNull ITaskInstance taskInfo) {
        VampirismMod.proxy.sendToServer(new ServerboundTaskActionPacket(taskInfo.getId(), taskInfo.getTaskBoard(), this.buttonAction(taskInfo)));
        this.taskWrapper.get(taskInfo.getTaskBoard()).removeTask(taskInfo, true);
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void setRefinement(int slot, @NotNull ItemStack stack) {
        this.refinementStacks.set(slot, (Object)stack);
    }

    @Override
    public void setReloadListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    private static /* synthetic */ boolean lambda$static$3(IPlayableFaction faction, ItemStack stack) {
        return stack.getItem() instanceof IRefinementItem && ((IRefinementItem)stack.getItem()).getSlotType() == IRefinementItem.AccessorySlotType.OBI_BELT && faction.equals(((IRefinementItem)stack.getItem()).getExclusiveFaction(stack));
    }

    private static /* synthetic */ boolean lambda$static$2(IPlayableFaction faction, ItemStack stack) {
        return stack.getItem() instanceof IRefinementItem && ((IRefinementItem)stack.getItem()).getSlotType() == IRefinementItem.AccessorySlotType.RING && faction.equals(((IRefinementItem)stack.getItem()).getExclusiveFaction(stack));
    }

    private static /* synthetic */ boolean lambda$static$1(IPlayableFaction faction, ItemStack stack) {
        return stack.getItem() instanceof IRefinementItem && ((IRefinementItem)stack.getItem()).getSlotType() == IRefinementItem.AccessorySlotType.AMULET && faction.equals(((IRefinementItem)stack.getItem()).getExclusiveFaction(stack));
    }

    public static class RemovingSelectorSlot
    extends InventoryContainerMenu.SelectorSlot {
        private RemovingSelectorSlot(@NotNull Container inventoryIn, int index, @NotNull InventoryContainerMenu.SelectorInfo info, Consumer<Container> refreshInvFunc, Function<Integer, Boolean> activeFunc) {
            super(inventoryIn, index, info, refreshInvFunc, activeFunc);
        }

        public void set(@NotNull ItemStack stack) {
            if (!stack.isEmpty()) {
                ((VampirismMenu)this.getContainer()).setRefinement(this.getSlotIndex(), stack);
            }
        }
    }
}

