/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.inventory.ModifiedItemCombinerMenuSlotDefinition;
import de.teamlapen.vampirism.mixin.accessor.ItemCombinerMenuAccessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTrainerMenu
extends ItemCombinerMenu {
    @NotNull
    private final Player player;
    @Nullable
    private final HunterTrainerEntity entity;
    @NotNull
    private Optional<HunterLeveling.HunterTrainerRequirement> lvlRequirement;

    @Deprecated
    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory, @Nullable HunterTrainerEntity trainer) {
        super((MenuType)ModMenus.HUNTER_TRAINER.get(), id, playerInventory, trainer == null ? ContainerLevelAccess.NULL : ContainerLevelAccess.create((Level)trainer.level(), (BlockPos)trainer.blockPosition()));
        this.player = playerInventory.player;
        this.entity = trainer;
        this.lvlRequirement = HunterLeveling.getTrainerRequirement(FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION) + 1);
    }

    protected boolean mayPickup(@NotNull Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void onTake(@NotNull Player player, @NotNull ItemStack stack) {
    }

    protected boolean isValidBlock(@NotNull BlockState pState) {
        return true;
    }

    public void createResult() {
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ModifiedItemCombinerMenuSlotDefinition.createWithoutResult().withSlot(0, 27, 26, stack -> this.lvlRequirement.filter(req -> req.ironQuantity() > 0).isPresent() && stack.is(Items.IRON_INGOT)).withSlot(1, 57, 26, stack -> this.lvlRequirement.filter(req -> req.goldQuantity() > 0).isPresent() && stack.is(Items.GOLD_INGOT)).withSlot(2, 86, 26, stack -> this.lvlRequirement.map(req -> req.tableRequirement().resultIntelItem().get()).filter(arg_0 -> ((ItemStack)stack).is(arg_0)).isPresent()).build();
    }

    public void createResultSlot(@NotNull ItemCombinerMenuSlotDefinition definition) {
    }

    public boolean canLevelup() {
        return this.lvlRequirement.map(req -> req.ironQuantity() <= this.getInputSlots().countItem(Items.IRON_INGOT) && req.goldQuantity() <= this.getInputSlots().countItem(Items.GOLD_INGOT) && this.getInputSlots().countItem((Item)req.tableRequirement().resultIntelItem().get()) >= 1).orElse(false);
    }

    public Optional<HunterLeveling.HunterTrainerRequirement> getRequirement() {
        return this.lvlRequirement;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            this.lvlRequirement.ifPresent(req -> {
                FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, req.targetLevel());
                InventoryHelper.removeItems(this.getInputSlots(), req.ironQuantity(), req.goldQuantity(), 1);
                this.player.addEffect(new MobEffectInstance(ModEffects.SATURATION, 400, 2));
                this.lvlRequirement = HunterLeveling.getTrainerRequirement(req.targetLevel() + 1);
            });
        }
    }

    private Container getInputSlots() {
        return ((ItemCombinerMenuAccessor)((Object)this)).getInputSlots();
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(player.getX(), player.getY(), player.getZ()).distanceToSqr(new Vec3(this.entity.getX(), this.entity.getY(), this.entity.getZ())) < 64.0;
    }
}

