/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SpeedEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public SpeedEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void deactivate(@NotNull T entity) {
        ((IFactionEntity)entity).asEntity().getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(ModRegistries.ENTITY_ACTIONS.getKey((Object)this));
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        if (entity.getTarget() == null) {
            return 0;
        }
        double distanceToTarget = new Vec3(entity.getX(), entity.getY(), entity.getZ()).subtract(entity.getTarget().getX(), entity.getTarget().getY(), entity.getTarget().getZ()).length();
        if (distanceToTarget > 10.0) {
            return 3;
        }
        if (distanceToTarget > 5.0) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onUpdate(@NotNull T entity, int duration) {
        ResourceLocation key = ModRegistries.ENTITY_ACTIONS.getKey((Object)this);
        if (!((IFactionEntity)entity).asEntity().getAttribute(Attributes.MOVEMENT_SPEED).hasModifier(key)) {
            ((IFactionEntity)entity).asEntity().getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(key, ((Double)VampirismConfig.BALANCE.eaSpeedAmount.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (duration % 5 == 0) {
            double maxDist = 0.5;
            ModParticles.spawnParticlesServer(entity.getCommandSenderWorld(), (ParticleOptions)ParticleTypes.CLOUD, entity.getX() + entity.getRandom().nextDouble() * maxDist - maxDist / 2.0, entity.getY() + 0.1, entity.getZ() + entity.getRandom().nextDouble() * maxDist - maxDist / 2.0, 3, 0.3f, 0.3f, 0.3f, 0.02f);
        }
    }
}

