/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrainingDummyVampireEntity
extends BasicVampireEntity {
    private final TargetingConditions PREDICATE = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private int startTicks = 0;
    private float damageTaken = 0.0f;

    public TrainingDummyVampireEntity(EntityType<? extends BasicVampireEntity> type, Level world) {
        super(type, world);
        this.disableImobConversion();
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        if (!this.level().isClientSide) {
            this.level().getNearbyPlayers(this.PREDICATE, (LivingEntity)this, this.getBoundingBox().inflate(40.0)).forEach(p -> p.displayClientMessage((Component)Component.literal((String)("Damage " + amount + " from " + damageSource.type().msgId())), false));
            if (this.startTicks != 0) {
                this.damageTaken += amount;
            }
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    public void convertToMinion(@NotNull Player lord) {
        super.convertToMinion(lord);
    }

    protected void actuallyHurt(@NotNull DamageSource damageSrc, float damageAmount) {
        if (damageSrc.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            super.actuallyHurt(damageSrc, damageAmount);
        }
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (this.startTicks == 0) {
                player.displayClientMessage((Component)Component.literal((String)"Start recording"), false);
                this.startTicks = this.tickCount;
            } else {
                player.displayClientMessage((Component)Component.literal((String)("Damage: " + this.damageTaken + " - DPS: " + this.damageTaken / (float)(this.tickCount - this.startTicks) * 20.0f)), false);
                this.discard();
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void registerGoals() {
    }
}

