/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.unlock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class LordLvlUnlocker
implements TaskUnlocker {
    public static final MapCodec<LordLvlUnlocker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("reqLordLevel").forGetter(i -> i.reqLordLevel), (App)Codec.BOOL.fieldOf("exact").forGetter(i -> i.exact)).apply((Applicative)inst, LordLvlUnlocker::new));
    private final int reqLordLevel;
    private final boolean exact;

    public LordLvlUnlocker(int reqLordLevel, boolean exact) {
        this.reqLordLevel = reqLordLevel;
        this.exact = exact;
    }

    public LordLvlUnlocker(int reqLordLevel) {
        this(reqLordLevel, false);
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)"text.vampirism.lord").append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"text.vampirism.level")).append((Component)Component.literal((String)((this.exact ? " = " : " ") + this.reqLordLevel)));
    }

    @Override
    public boolean isUnlocked(@NotNull IFactionPlayer<?> playerEntity) {
        int aL = FactionPlayerHandler.get(playerEntity.asEntity()).getLordLevel();
        return this.exact ? aL == this.reqLordLevel : aL >= this.reqLordLevel;
    }

    @Override
    public MapCodec<? extends TaskUnlocker> codec() {
        return (MapCodec)ModTasks.LORD_LEVEL_UNLOCKER.get();
    }
}

