/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.req;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record EntityRequirement(@NotNull ResourceLocation id, @NotNull EntityType<?> entityType, @Range(from=0L, to=0x7FFFFFFFL) int amount, @NotNull Component description) implements TaskRequirement.Requirement<EntityType<?>>
{
    public static final MapCodec<EntityRequirement> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("id").forGetter(s -> Optional.of(s.id)), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entityType").forGetter(i -> i.entityType), (App)Codec.INT.fieldOf("amount").forGetter(s -> s.amount), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(s -> s.description)).apply((Applicative)inst, (id, type, amount, desc) -> new EntityRequirement(id.orElseGet(() -> RegUtil.id(type)), (EntityType<?>)type, (int)amount, (Component)desc)));

    public EntityRequirement(@NotNull EntityType<?> entityType, int amount, Component component) {
        this(RegUtil.id(entityType), entityType, amount, component);
    }

    @Override
    public int getAmount(IFactionPlayer<?> player) {
        return this.amount;
    }

    @Override
    @NotNull
    public EntityType<?> getStat(IFactionPlayer<?> player) {
        return this.entityType;
    }

    @Override
    @NotNull
    public TaskRequirement.Type getType() {
        return TaskRequirement.Type.ENTITY;
    }

    @Override
    public MapCodec<? extends TaskRequirement.Requirement<?>> codec() {
        return (MapCodec)ModTasks.ENTITY_REQUIREMENT.get();
    }
}

