/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.lib.storage.ISavable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskManager;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.TaskInstance;
import de.teamlapen.vampirism.entity.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.inventory.TaskBoardMenu;
import de.teamlapen.vampirism.inventory.TaskMenu;
import de.teamlapen.vampirism.inventory.VampirismMenu;
import de.teamlapen.vampirism.network.ClientboundTaskPacket;
import de.teamlapen.vampirism.network.ClientboundTaskStatusPacket;
import de.teamlapen.vampirism.network.ServerboundTaskActionPacket;
import de.teamlapen.vampirism.util.CodecUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskManager
implements ITaskManager,
ISavable {
    private static final String NBT_KEY = "task_manager";
    private static final UUID UNIQUE_TASKS = UUID.fromString("e2c6068a-8f0e-4d5b-822a-38ad6ecf98c9");
    @NotNull
    private final IPlayableFaction<?> faction;
    @NotNull
    private final ServerPlayer player;
    @NotNull
    private final IFactionPlayer<?> factionPlayer;
    @NotNull
    private final Set<ResourceKey<Task>> completedTasks = new HashSet<ResourceKey<Task>>();
    @NotNull
    private final Map<UUID, TaskWrapper> taskWrapperMap = new HashMap<UUID, TaskWrapper>();
    private final Registry<Task> registry;

    public TaskManager(@NotNull ServerPlayer player, @NotNull IFactionPlayer<?> factionPlayer, @NotNull IPlayableFaction<?> faction) {
        this.faction = faction;
        this.player = player;
        this.factionPlayer = factionPlayer;
        this.registry = player.level().registryAccess().registryOrThrow(VampirismRegistries.Keys.TASK);
    }

    @Override
    public void abortTask(UUID taskBoardId, @NotNull UUID taskInstance, boolean remove) {
        this.taskWrapperMap.get(taskBoardId).removeTask(taskInstance, remove);
    }

    @Override
    public void acceptTask(UUID taskBoardId, @NotNull UUID taskInstance) {
        this.player.awardStat((ResourceLocation)ModStats.TASKS_ACCEPTED.get());
        ITaskInstance ins = this.taskWrapperMap.get(taskBoardId).acceptTask(taskInstance, this.player.level().getGameTime() + (long)this.getTaskTimeConfig() * 1200L);
        this.updateStats(ins);
    }

    public void handleTaskActionMessage(@NotNull ServerboundTaskActionPacket msg) {
        switch (msg.action()) {
            case COMPLETE: {
                this.completeTask(msg.entityId(), msg.task());
                break;
            }
            case ACCEPT: {
                this.acceptTask(msg.entityId(), msg.task());
                break;
            }
            default: {
                this.abortTask(msg.entityId(), msg.task(), msg.action() == TaskMenu.TaskAction.REMOVE);
            }
        }
    }

    public void applyRewards(@NotNull ITaskInstance taskInstance) {
        taskInstance.getReward().applyReward(this.factionPlayer);
    }

    public boolean canCompleteTask(@NotNull ITaskInstance taskInstance) {
        if (!this.isTaskUnlocked(taskInstance.getTask())) {
            return false;
        }
        if (!this.isTimeEnough(taskInstance, this.player.level().getGameTime())) {
            return false;
        }
        for (TaskRequirement.Requirement<?> requirement : this.getTask(taskInstance.getTask()).getRequirement().getAll()) {
            if (this.checkStat(taskInstance, requirement)) continue;
            return false;
        }
        return true;
    }

    private Task getTask(ResourceKey<Task> key) {
        return (Task)this.registry.get(key.location());
    }

    @Override
    public void completeTask(UUID taskBoardId, @NotNull UUID taskInstance) {
        TaskWrapper wrapper = this.taskWrapperMap.get(taskBoardId);
        ITaskInstance ins = wrapper.getTaskInstance(taskInstance);
        if (!this.canCompleteTask(ins)) {
            return;
        }
        this.completedTasks.add(ins.getTask());
        wrapper.removeTask(ins, true);
        if (!ins.isUnique(this.registry)) {
            ++wrapper.lessTasks;
        }
        this.removeRequirements(ins);
        this.applyRewards(ins);
        this.player.awardStat((ResourceLocation)ModStats.TASKS_COMPLETED.get());
    }

    @NotNull
    public Map<UUID, Map<ResourceLocation, Integer>> getCompletedRequirements(@NotNull Collection<ITaskInstance> taskInstances) {
        HashMap completedRequirements = Maps.newHashMap();
        taskInstances.forEach(task -> {
            Map<ResourceLocation, Integer> completed = this.getCompletedRequirements((ITaskInstance)task);
            if (!completed.isEmpty()) {
                completedRequirements.put(task.getId(), completed);
            }
        });
        return completedRequirements;
    }

    public int getTaskTimeConfig() {
        if (ServerLifecycleHooks.getCurrentServer().isDedicatedServer()) {
            return (Integer)VampirismConfig.BALANCE.taskDurationDedicatedServer.get();
        }
        return (Integer)VampirismConfig.BALANCE.taskDurationSinglePlayer.get();
    }

    @Override
    public boolean hasAvailableTasks(@NotNull UUID taskBoardId) {
        return !this.getTasks(taskBoardId).isEmpty() || !this.getUniqueTasks().isEmpty();
    }

    public boolean isTaskUnlocked(@NotNull ResourceKey<Task> task) {
        if (!this.matchesFaction(task)) {
            return false;
        }
        for (TaskUnlocker taskUnlocker : this.getTask(task).getUnlocker()) {
            if (taskUnlocker.isUnlocked(this.factionPlayer)) continue;
            return false;
        }
        return true;
    }

    public boolean isTaskUnlocked(@NotNull Holder<Task> task) {
        if (!this.matchesFaction(task)) {
            return false;
        }
        for (TaskUnlocker taskUnlocker : ((Task)task.value()).getUnlocker()) {
            if (taskUnlocker.isUnlocked(this.factionPlayer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openTaskMasterScreen(@NotNull UUID taskBoardId) {
        if (this.player.containerMenu instanceof TaskBoardMenu) {
            TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
            HashSet<ITaskInstance> selectedTasks = new HashSet<ITaskInstance>(this.getTasks(taskBoardId));
            selectedTasks.addAll(this.getUniqueTasks());
            this.player.connection.send((CustomPacketPayload)new ClientboundTaskStatusPacket(selectedTasks, this.getCompletableTasks(selectedTasks), this.getCompletedRequirements(selectedTasks), this.player.containerMenu.containerId, taskBoardId));
            wrapper.lastSeenPos = this.player.blockPosition();
        }
    }

    @Override
    public void openVampirismMenu() {
        if (!this.player.isAlive()) {
            return;
        }
        this.player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, player) -> new VampirismMenu(i, inventory), (Component)Component.empty()));
        if (this.player.containerMenu instanceof TaskMenu) {
            this.player.connection.send((CustomPacketPayload)new ClientboundTaskPacket(this.player.containerMenu.containerId, this.taskWrapperMap, this.taskWrapperMap.entrySet().stream().map(entry -> Pair.of((Object)((UUID)entry.getKey()), this.getCompletableTasks(((TaskWrapper)entry.getValue()).getAcceptedTasks()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)), this.taskWrapperMap.values().stream().map(wrapper -> Pair.of((Object)wrapper.id, this.getCompletedRequirements(wrapper.tasks.values()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue))));
        }
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        if (compoundNBT.contains("taskWrapper")) {
            ListTag infos = compoundNBT.getList("taskWrapper", 10);
            for (int i = 0; i < infos.size(); ++i) {
                CompoundTag nbt = infos.getCompound(i);
                Optional decode = TaskWrapper.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt).map(com.mojang.datafixers.util.Pair::getFirst).result();
                decode.ifPresent(wrapper -> this.taskWrapperMap.put(wrapper.id, (TaskWrapper)wrapper));
            }
        }
        if (compoundNBT.contains("completedTasks")) {
            compoundNBT.getCompound("completedTasks").getAllKeys().forEach(taskId -> {
                ResourceKey key = ResourceKey.create(VampirismRegistries.Keys.TASK, (ResourceLocation)ResourceLocation.parse((String)taskId));
                if (this.registry.containsKey(key)) {
                    this.completedTasks.add((ResourceKey<Task>)key);
                }
            });
        }
    }

    public void removeRequirements(@NotNull ITaskInstance taskInstance) {
        this.getTask(taskInstance.getTask()).getRequirement().removeRequirement(this.factionPlayer);
    }

    @Override
    public void reset() {
        this.completedTasks.clear();
        this.taskWrapperMap.values().forEach(wrapper -> {
            wrapper.lessTasks = 0;
            wrapper.tasks.clear();
        });
    }

    @Override
    public void resetTaskLists() {
        this.taskWrapperMap.values().forEach(TaskWrapper::reset);
        this.updateTaskLists();
    }

    @Override
    public void resetUniqueTask(@NotNull ResourceKey<Task> id) {
        this.registry.getHolder(id).filter(a -> a.is(ModTags.Tasks.IS_UNIQUE)).ifPresent(task -> {
            this.completedTasks.remove(task.key());
            TaskWrapper wrapper = this.taskWrapperMap.get(UNIQUE_TASKS);
            if (wrapper != null) {
                wrapper.tasks.values().removeIf(ins -> task.is(ins.getTask()));
            }
        });
    }

    public void tick() {
        if (this.player.getCommandSenderWorld().getGameTime() % 24000L == 0L) {
            this.updateTaskLists();
        }
    }

    @Override
    public void updateTaskLists() {
        for (TaskWrapper value : this.taskWrapperMap.values()) {
            if (value.id == UNIQUE_TASKS) continue;
            if (value.getAcceptedTasks().isEmpty()) {
                value.tasks.clear();
                continue;
            }
            value.tasks.values().removeIf(task -> !value.getAcceptedTasks().contains(task));
        }
    }

    @Override
    public boolean wasTaskCompleted(@NotNull ResourceKey<Task> task) {
        return this.completedTasks.contains(task);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        if (!this.completedTasks.isEmpty()) {
            CompoundTag tasksNBT = new CompoundTag();
            this.completedTasks.forEach(key -> tasksNBT.putBoolean(key.location().toString(), true));
            compoundNBT.put("completedTasks", (Tag)tasksNBT);
        }
        if (!this.taskWrapperMap.isEmpty()) {
            ListTag infos = new ListTag();
            this.taskWrapperMap.forEach((a, b) -> {
                DataResult result = TaskWrapper.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, b);
                infos.add((Object)((Tag)result.getOrThrow()));
            });
            compoundNBT.put("taskWrapper", (Tag)infos);
        }
        return compoundNBT;
    }

    private boolean checkStat(@NotNull ITaskInstance taskInstance, @NotNull TaskRequirement.Requirement<?> requirement) {
        return this.getStat(taskInstance, requirement) >= requirement.getAmount(this.factionPlayer);
    }

    @NotNull
    private Set<UUID> getCompletableTasks(@NotNull Set<ITaskInstance> taskInstances) {
        return taskInstances.stream().filter(this::canCompleteTask).map(ITaskInstance::getId).collect(Collectors.toSet());
    }

    @NotNull
    private Map<ResourceLocation, Integer> getCompletedRequirements(@NotNull ITaskInstance taskInstance) {
        HashMap<ResourceLocation, Integer> completed = new HashMap<ResourceLocation, Integer>();
        for (TaskRequirement.Requirement<?> requirement : this.getTask(taskInstance.getTask()).getRequirement().getAll()) {
            completed.put(requirement.id(), this.getStat(taskInstance, requirement));
        }
        return completed;
    }

    private int getStat(@NotNull ITaskInstance taskInstance, @NotNull TaskRequirement.Requirement<?> requirement) {
        Map<ResourceLocation, Integer> stats = taskInstance.getStats();
        if (!taskInstance.isAccepted()) {
            return 0;
        }
        int neededStat = 0;
        int actualStat = 0;
        switch (requirement.getType()) {
            case STATS: {
                actualStat = this.player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.id()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY: {
                actualStat = this.player.getStats().getValue(Stats.ENTITY_KILLED.get((Object)((EntityType)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.id()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY_TAG: {
                actualStat += BuiltInRegistries.ENTITY_TYPE.getTag((TagKey)requirement.getStat(this.factionPlayer)).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).mapToInt(type -> this.player.getStats().getValue(Stats.ENTITY_KILLED.get(type))).sum();
                neededStat = stats.get(requirement.id()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ITEMS: {
                ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                neededStat = stack.getCount();
                actualStat = UtilLib.countItemWithComponent(this.player.getInventory(), stack, false);
                break;
            }
            case BOOLEAN: {
                if (!((Boolean)requirement.getStat(this.factionPlayer)).booleanValue()) {
                    return 0;
                }
                return 1;
            }
        }
        return Math.min(requirement.getAmount(this.factionPlayer) - (neededStat - actualStat), requirement.getAmount(this.factionPlayer));
    }

    @NotNull
    private Collection<ITaskInstance> getTasks(@NotNull UUID taskBoardId) {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
        if (!wrapper.tasks.isEmpty()) {
            this.removeLockedTasks(wrapper.getTaskInstances());
        }
        int n = wrapper.taskAmount = wrapper.taskAmount < 0 ? this.player.getRandom().nextInt(((Integer)VampirismConfig.BALANCE.taskMasterMaxTaskAmount.get()).intValue()) + 1 - wrapper.lessTasks : wrapper.taskAmount;
        if (wrapper.tasks.size() < wrapper.taskAmount) {
            List tasks = this.registry.holders().collect(Collectors.toList());
            Collections.shuffle(tasks);
            wrapper.tasks.putAll(tasks.stream().filter(this::matchesFaction).filter(task -> !task.is(ModTags.Tasks.IS_UNIQUE)).filter(this::isTaskUnlocked).limit(wrapper.taskAmount - wrapper.tasks.size()).map(task -> new TaskInstance((Holder.Reference<Task>)task, taskBoardId, this.factionPlayer, (long)this.getTaskTimeConfig() * 1200L)).collect(Collectors.toMap(TaskInstance::getId, t -> t)));
        }
        this.updateStats(wrapper.getTaskInstances());
        return wrapper.getTaskInstances();
    }

    @NotNull
    private Collection<ITaskInstance> getUniqueTasks() {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UNIQUE_TASKS, TaskWrapper::new);
        Map<UUID, ITaskInstance> uniqueTasks = wrapper.tasks;
        if (!uniqueTasks.isEmpty()) {
            this.removeLockedTasks(uniqueTasks.values());
        }
        Collection tasks = uniqueTasks.values().stream().map(ITaskInstance::getTask).collect(Collectors.toSet());
        uniqueTasks.putAll(this.registry.holders().filter(this::matchesFaction).filter(t -> t.is(ModTags.Tasks.IS_UNIQUE)).filter(task -> !tasks.contains(task.key())).filter(task -> !this.completedTasks.contains(task.key())).filter(this::isTaskUnlocked).map(task -> new TaskInstance((Holder.Reference<Task>)task, UNIQUE_TASKS, this.factionPlayer, 0L)).collect(Collectors.toMap(TaskInstance::getId, a -> a)));
        wrapper.tasks.putAll(uniqueTasks);
        this.updateStats(uniqueTasks.values());
        return uniqueTasks.values();
    }

    private boolean isTimeEnough(@NotNull ITaskInstance taskInstance, long gameTime) {
        if (!taskInstance.isUnique(this.registry)) {
            return taskInstance.getTaskTimeStamp() >= gameTime;
        }
        return true;
    }

    private boolean matchesFaction(@NotNull ResourceKey<Task> task) {
        return this.registry.getHolder(task).map(this::matchesFaction).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesFaction(@NotNull Holder<Task> task) {
        if (!task.is(ModTags.Tasks.HAS_FACTION)) return true;
        if (this.faction.getTag(VampirismRegistries.Keys.TASK).map(arg_0 -> task.is(arg_0)).orElse(false) == false) return false;
        return true;
    }

    private void removeLockedTasks(@NotNull Collection<ITaskInstance> taskInstances) {
        taskInstances.removeIf(task -> {
            if (!this.isTaskUnlocked(task.getTask())) {
                task.aboardTask();
                return true;
            }
            return false;
        });
    }

    private void updateStats(@NotNull Collection<ITaskInstance> taskInstances) {
        taskInstances.forEach(this::updateStats);
    }

    private void updateStats(@NotNull ITaskInstance taskInstance) {
        if (!taskInstance.isAccepted()) {
            return;
        }
        Task task = this.getTask(taskInstance.getTask());
        if (!task.getRequirement().isHasStatBasedReq()) {
            return;
        }
        Map<ResourceLocation, Integer> reqStats = taskInstance.getStats();
        for (TaskRequirement.Requirement<?> requirement : task.getRequirement().getAll()) {
            switch (requirement.getType()) {
                case STATS: {
                    reqStats.putIfAbsent(requirement.id(), this.player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY: {
                    reqStats.putIfAbsent(requirement.id(), this.player.getStats().getValue(Stats.ENTITY_KILLED.get((Object)((EntityType)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY_TAG: {
                    reqStats.putIfAbsent(requirement.id(), BuiltInRegistries.ENTITY_TYPE.getTag((TagKey)requirement.getStat(this.factionPlayer)).stream().flatMap(s -> s.stream()).map(s -> (EntityType)s.value()).mapToInt(type -> this.player.getStats().getValue(Stats.ENTITY_KILLED.get(type))).sum());
                    break;
                }
            }
        }
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    public static class TaskWrapper {
        public static final Codec<TaskWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtil.UUID.fieldOf("id").forGetter(i -> i.id), (App)Codec.INT.fieldOf("lessTasks").forGetter(i -> i.lessTasks), (App)Codec.INT.fieldOf("taskAmount").forGetter(i -> i.taskAmount), (App)Codec.unboundedMap(CodecUtil.UUID, TaskInstance.CODEC).fieldOf("tasksSize").forGetter(i -> i.tasks), (App)BlockPos.CODEC.optionalFieldOf("lastSeenPos").forGetter(i -> Optional.ofNullable(i.lastSeenPos))).apply((Applicative)instance, TaskWrapper::new));
        private final UUID id;
        @NotNull
        private final Map<UUID, ITaskInstance> tasks;
        private int lessTasks;
        private int taskAmount;
        @Nullable
        private BlockPos lastSeenPos;

        public TaskWrapper(UUID id) {
            this.id = id;
            this.lessTasks = 0;
            this.taskAmount = -1;
            this.tasks = new HashMap<UUID, ITaskInstance>();
            this.lastSeenPos = null;
        }

        private TaskWrapper(UUID id, int lessTasks, int taskAmount, @NotNull Map<UUID, TaskInstance> tasks, @Nullable Optional<BlockPos> lastSeenPos) {
            this.id = id;
            this.lessTasks = lessTasks;
            this.taskAmount = taskAmount;
            this.tasks = new HashMap<UUID, TaskInstance>(tasks);
            this.lastSeenPos = lastSeenPos.orElse(null);
        }

        @NotNull
        public ITaskInstance acceptTask(UUID taskInstance, long timeStamp) {
            ITaskInstance ins = this.tasks.get(taskInstance);
            ins.startTask(timeStamp);
            return ins;
        }

        public void encode(@NotNull FriendlyByteBuf buffer) {
            buffer.writeUUID(this.id);
            buffer.writeVarInt(this.lessTasks);
            buffer.writeVarInt(this.taskAmount);
            buffer.writeBoolean(this.lastSeenPos != null);
            if (this.lastSeenPos != null) {
                buffer.writeBlockPos(this.lastSeenPos);
            }
            buffer.writeVarInt(this.tasks.size());
            this.tasks.values().forEach(taskInstance -> taskInstance.encode(buffer));
        }

        @NotNull
        public Set<ITaskInstance> getAcceptedTasks() {
            return this.tasks.values().stream().filter(ITaskInstance::isAccepted).collect(Collectors.toSet());
        }

        public UUID getId() {
            return this.id;
        }

        @NotNull
        public Optional<BlockPos> getLastSeenPos() {
            return Optional.ofNullable(this.lastSeenPos);
        }

        public ITaskInstance getTaskInstance(UUID taskInstance) {
            return this.tasks.get(taskInstance);
        }

        @NotNull
        public Collection<ITaskInstance> getTaskInstances() {
            return this.tasks.values();
        }

        public void removeTask(@NotNull ITaskInstance taskInstance, boolean delete) {
            if (delete) {
                this.tasks.remove(taskInstance.getId());
            }
            taskInstance.aboardTask();
        }

        public void removeTask(UUID taskInstance, boolean delete) {
            this.removeTask(this.tasks.get(taskInstance), delete);
        }

        private void reset() {
            this.tasks.clear();
            this.lessTasks = 0;
            this.taskAmount = -1;
        }
    }
}

