/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.entity.hunter.IVampirismCrossbowUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.RangedHunterCrossbowAttackGoal;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.crossbow.ArrowContainer;
import de.teamlapen.vampirism.items.crossbow.TechCrossbowItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HunterMinionEntity
extends MinionEntity<HunterMinionData>
implements IHunter,
IVampirismCrossbowUser {
    private static final EntityDataAccessor<Boolean> RAISED_ARM = SynchedEntityData.defineId(HunterMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(HunterMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return BasicHunterEntity.getAttributeBuilder();
    }

    public HunterMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.HUNTER_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Creeper)));
    }

    @Override
    @NotNull
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)MinionTasks.FOLLOW_LORD.get(), (IMinionTask)MinionTasks.DEFEND_AREA.get(), (IMinionTask)MinionTasks.STAY.get(), (IMinionTask)MinionTasks.COLLECT_HUNTER_ITEMS.get(), (IMinionTask)MinionTasks.PROTECT_LORD.get()});
    }

    public void setHatType(int type) {
        assert (type >= -1);
        this.getMinionData().ifPresent(d -> {
            d.hat = type;
        });
    }

    public int getHunterType() {
        return this.getMinionData().map(d -> d.type).map(t -> Math.max(0, t)).orElse(0);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public boolean hasMinionSpecificSkin() {
        return this.getMinionData().map(d -> d.minionSkin).orElse(false);
    }

    public int getHatType() {
        return this.getItemBySlot(EquipmentSlot.HEAD).isEmpty() ? this.getMinionData().map(d -> d.hat).orElse(0) : -1;
    }

    @Override
    public void openAppearanceScreen() {
        VampirismMod.proxy.displayHunterMinionAppearanceScreen(this);
    }

    @Override
    public void openStatsScreen() {
        VampirismMod.proxy.displayHunterMinionStatsScreen(this);
    }

    public void setHunterType(int type, boolean minionSkin) {
        this.getMinionData().ifPresent(d -> {
            d.type = type;
            d.minionSkin = minionSkin;
        });
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> {
            d.useLordSkin = useLordSkin;
        });
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> d.useLordSkin).orElse(false);
    }

    @Override
    protected boolean canConsume(@NotNull ItemStack stack) {
        if (!super.canConsume(stack)) {
            return false;
        }
        boolean fullHealth = this.getHealth() == this.getMaxHealth();
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)this);
        return foodProperties == null || !fullHealth || foodProperties.canAlwaysEat();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RAISED_ARM, (Object)false);
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
    }

    @Override
    protected void onMinionDataReceived(HolderLookup.Provider provider, @NotNull HunterMinionData data) {
        super.onMinionDataReceived(provider, data);
        this.updateAttackGoal();
        this.updateAttributes();
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.level().isClientSide() && this.isLord(player) && this.minionData != null && (heldItem = player.getItemInHand(hand)).getItem() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.getItem()).getFaction() == this.getFaction()) {
            if (((HunterMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.getItem()).getMinLevel() && ((HunterMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.getItem()).getMaxLevel()) {
                ++((HunterMinionData)this.minionData).level;
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.hunter_minion.equipment_upgrade"), false);
                HelperLib.sync(this);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.hunter_minion.equipment_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new RangedHunterCrossbowAttackGoal<HunterMinionEntity>(this, 0.8, 60.0f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
    }

    private void updateAttackGoal() {
        if (this.level().isClientSide()) {
            return;
        }
    }

    public void updateAttributes() {
        float statsMultiplier = this.getMinionData().filter(d -> d.hasIncreasedStats).map(a -> Float.valueOf(1.2f)).orElse(Float.valueOf(1.0f)).floatValue();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(HunterMinionData::getHealthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue((3.0 + 1.0 * (double)this.getMinionData().map(HunterMinionData::getStrengthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED * (double)statsMultiplier);
    }

    public void setChargingCrossbow(boolean p_213671_1_) {
        this.getEntityData().set(IS_CHARGING_CROSSBOW, (Object)p_213671_1_);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void performRangedAttack(LivingEntity p_82196_1_, float p_82196_2_) {
        this.performCrossbowAttack((LivingEntity)this, 1.6f);
    }

    @Override
    public boolean isHoldingCrossbow() {
        return this.isHolding(stack -> stack.getItem() instanceof IVampirismCrossbow);
    }

    @Override
    public boolean canUseCrossbow(ItemStack stack) {
        return stack.getItem() instanceof TechCrossbowItem ? this.getLordOpt().map(p -> HunterPlayer.get(p.getPlayer()).getSkillHandler().isSkillEnabled((ISkill)HunterSkills.MINION_TECH_CROSSBOWS.get())).orElse(false) : true;
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.getEntityData().get(IS_CHARGING_CROSSBOW);
    }

    @NotNull
    public ItemStack getProjectile(ItemStack stack) {
        if (stack.getItem() instanceof IVampirismCrossbow) {
            if (stack.getItem() instanceof TechCrossbowItem) {
                ItemStack clip = ((ArrowContainer)ModItems.ARROW_CLIP.get()).getDefaultInstance();
                ((ArrowContainer)ModItems.ARROW_CLIP.get()).addArrows(clip, Collections.nCopies(12, ((CrossbowArrowItem)ModItems.CROSSBOW_ARROW_NORMAL.get()).getDefaultInstance()));
                return clip;
            }
            return ((CrossbowArrowItem)ModItems.CROSSBOW_ARROW_NORMAL.get()).getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlot slotType) {
        Predicate<ItemStack> predicate = super.getEquipmentPredicate(slotType);
        if (slotType == EquipmentSlot.MAINHAND) {
            predicate = predicate.and(stack -> !(stack.getItem() instanceof TechCrossbowItem) || HunterPlayer.get(this.getLord().getPlayer()).getSkillHandler().isSkillEnabled((ISkill)HunterSkills.MINION_TECH_CROSSBOWS.get()));
        }
        return predicate;
    }

    public static class HunterMinionData
    extends MinionData {
        public static final ResourceLocation ID = VResourceLocation.mod("hunter");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int type;
        private int hat;
        private boolean useLordSkin;
        private boolean minionSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;
        private boolean hasIncreasedStats;

        public HunterMinionData(String name, int type, int hat, boolean useLordSkin, boolean hasIncreasedStats) {
            super(name, 9);
            this.type = type;
            this.hat = hat;
            this.useLordSkin = useLordSkin;
            this.level = 0;
            this.minionSkin = false;
            this.hasIncreasedStats = hasIncreasedStats;
        }

        public HunterMinionData() {
        }

        @Override
        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.type = nbt.getInt("hunter_type");
            this.hat = nbt.getInt("hunter_hat");
            this.level = nbt.getInt("level");
            this.useLordSkin = nbt.getBoolean("use_lord_skin");
            this.inventoryLevel = nbt.getInt("l_inv");
            this.healthLevel = nbt.getInt("l_he");
            this.strengthLevel = nbt.getInt("l_str");
            this.resourceEfficiencyLevel = nbt.getInt("l_res");
            this.minionSkin = nbt.getBoolean("ms");
            this.hasIncreasedStats = nbt.getBoolean("hasIncreasedStats");
        }

        @Override
        @NotNull
        public MutableComponent getFormattedName() {
            return super.getFormattedName().withStyle(style -> style.withColor(VReference.HUNTER_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        @Override
        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.resourceEfficiencyLevel - this.strengthLevel);
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, @NotNull List<Integer> data) {
            this.setName(newName);
            block5: for (int i = 0; i < data.size(); ++i) {
                switch (i) {
                    case 0: {
                        this.type = data.get(i);
                        continue block5;
                    }
                    case 1: {
                        this.hat = data.get(i);
                        continue block5;
                    }
                    case 2: {
                        this.useLordSkin = (data.get(i) & 1) == 1;
                        this.minionSkin = (data.get(i) & 2) == 2;
                    }
                }
            }
        }

        @Override
        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.resourceEfficiencyLevel > 0;
        }

        @Override
        public void resetStats(MinionEntity<?> entity) {
            assert (entity instanceof HunterMinionEntity);
            this.inventoryLevel = 0;
            this.healthLevel = 0;
            this.strengthLevel = 0;
            this.resourceEfficiencyLevel = 0;
            this.shrinkInventory(entity);
            ((HunterMinionEntity)entity).updateAttributes();
            super.resetStats(entity);
        }

        @Override
        public void serializeNBT(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.serializeNBT(tag, provider);
            tag.putInt("hunter_type", this.type);
            tag.putInt("hunter_hat", this.hat);
            tag.putInt("level", this.level);
            tag.putInt("l_inv", this.inventoryLevel);
            tag.putInt("l_he", this.healthLevel);
            tag.putInt("l_str", this.strengthLevel);
            tag.putInt("l_res", this.resourceEfficiencyLevel);
            tag.putBoolean("use_lord_skin", this.useLordSkin);
            tag.putBoolean("ms", this.minionSkin);
            tag.putBoolean("hasIncreasedStats", this.hasIncreasedStats);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof HunterMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    entity.setHealth(entity.getMaxHealth());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void setIncreasedStats(boolean hasIncreasedStats) {
            this.hasIncreasedStats = hasIncreasedStats;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setUseLordSkin(boolean useLordSkin) {
            this.useLordSkin = useLordSkin;
        }

        public void setHat(int hat) {
            this.hat = hat;
        }
    }
}

