/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggressiveVillagerEntity
extends VampirismVillagerEntity
implements IHunterMob,
IAggressiveVillager,
IVillageCaptureEntity {
    @Nullable
    private ICaptureAttributes villageAttributes;

    @NotNull
    public static AggressiveVillagerEntity makeHunter(@NotNull Villager villager) {
        AggressiveVillagerEntity hunter = (AggressiveVillagerEntity)((EntityType)ModEntities.VILLAGER_ANGRY.get()).create(villager.level());
        assert (hunter != null);
        CompoundTag nbt = new CompoundTag();
        if (villager.isSleeping()) {
            villager.stopSleeping();
        }
        villager.saveWithoutId(nbt);
        hunter.load(nbt);
        hunter.setUUID(Mth.createInsecureUUID((RandomSource)hunter.random));
        hunter.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.PITCHFORK.get()));
        return hunter;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismVillagerEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, BalanceMobProps.mobProps.HUNTER_VILLAGER_MAX_HEALTH);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public AggressiveVillagerEntity(EntityType<? extends AggressiveVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    @Override
    public void attackVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    public void defendVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return false;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.PITCHFORK.get()));
        return data;
    }

    public void refreshBrain(@NotNull ServerLevel serverWorldIn) {
    }

    @Override
    public void stopVillageAttackDefense() {
        Villager villager = (Villager)EntityType.VILLAGER.create(this.level());
        assert (villager != null);
        this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        CompoundTag nbt = new CompoundTag();
        this.saveWithoutId(nbt);
        villager.load(nbt);
        villager.setUUID(Mth.createInsecureUUID((RandomSource)this.random));
        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)villager);
    }

    @NotNull
    protected Component getTypeName() {
        return this.getType().getDescription();
    }

    protected void registerBrainGoals(@NotNull Brain<Villager> brainIn) {
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.55, false, 400, () -> true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.targetSelector.addGoal(3, new DefendVillageGoal<AggressiveVillagerEntity>(this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal<PathfinderMob>(this, (Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double getFollowDistance() {
                return super.getFollowDistance() / 2.0;
            }
        });
    }
}

