/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialConvertingHandler<T extends PathfinderMob, Z extends PathfinderMob>
extends DefaultConvertingHandler<T> {
    private final Supplier<EntityType<Z>> convertedType;

    public SpecialConvertingHandler(Supplier<EntityType<Z>> convertedType, ResourceLocation overlayTexture) {
        super(null, overlayTexture);
        this.convertedType = convertedType;
    }

    public SpecialConvertingHandler(Supplier<EntityType<Z>> convertedType, ResourceLocation overlayTexture, IConvertingHandler.IDefaultHelper attributeHelper) {
        super(attributeHelper, overlayTexture);
        this.convertedType = convertedType;
    }

    public EntityType<Z> getConvertedType() {
        return this.convertedType.get();
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(@NotNull T entity) {
        return Helper.createEntity(this.convertedType.get(), entity.getCommandSenderWorld()).map(convertedCreature -> {
            this.copyImportantStuff(convertedCreature, entity);
            convertedCreature.setUUID(Mth.createInsecureUUID((RandomSource)convertedCreature.getRandom()));
            convertedCreature.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            ((ICurableConvertedCreature)convertedCreature).getSourceEntityDataParamOpt().ifPresent(s -> ((IFactionEntity)convertedCreature).asEntity().getEntityData().set(s, (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString()));
            return convertedCreature;
        }).orElse(null);
    }

    protected void copyImportantStuff(@NotNull Z converted, @NotNull T entity) {
        CompoundTag nbt = new CompoundTag();
        entity.saveWithoutId(nbt);
        ((PathfinderMob)converted).yBodyRot = ((PathfinderMob)entity).yBodyRot;
        ((PathfinderMob)converted).yHeadRot = ((PathfinderMob)entity).yHeadRot;
        converted.load(nbt);
        this.updateEntityAttributes((PathfinderMob)converted);
        converted.setHealth(converted.getMaxHealth() / 3.0f * 2.0f);
    }
}

