/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.hunter.IVampirismCrossbowUser;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.items.crossbow.TechCrossbowItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;

public class RangedHunterCrossbowAttackGoal<T extends PathfinderMob & IVampirismCrossbowUser>
extends RangedCrossbowAttackGoal<T> {
    public RangedHunterCrossbowAttackGoal(T mob, double speed, float radius) {
        super(mob, speed, radius);
    }

    public boolean canUse() {
        return super.canUse() && this.canUseCrossbow();
    }

    private boolean canUseCrossbow() {
        ItemStack stack = ((PathfinderMob)this.mob).getMainHandItem();
        if (stack.getItem() instanceof IVampirismCrossbow) {
            return ((IVampirismCrossbowUser)((PathfinderMob)this.mob)).canUseCrossbow(stack);
        }
        stack = ((PathfinderMob)this.mob).getOffhandItem();
        if (stack.getItem() instanceof IVampirismCrossbow) {
            return ((IVampirismCrossbowUser)((PathfinderMob)this.mob)).canUseCrossbow(stack);
        }
        return false;
    }

    public void tick() {
        LivingEntity livingentity = ((PathfinderMob)this.mob).getTarget();
        if (livingentity != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = ((PathfinderMob)this.mob).getSensing().hasLineOfSight((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = ((PathfinderMob)this.mob).distanceToSqr((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    ((PathfinderMob)this.mob).getNavigation().moveTo((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(((PathfinderMob)this.mob).getRandom());
                }
            } else {
                this.updatePathDelay = 0;
                ((PathfinderMob)this.mob).getNavigation().stop();
            }
            ((PathfinderMob)this.mob).getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == RangedCrossbowAttackGoal.CrossbowState.UNCHARGED) {
                if (!flag2) {
                    ((PathfinderMob)this.mob).startUsingItem(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, IVampirismCrossbow.class::isInstance));
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.CHARGING;
                    ((CrossbowAttackMob)((PathfinderMob)this.mob)).setChargingCrossbow(true);
                }
            } else if (this.crossbowState == RangedCrossbowAttackGoal.CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!((PathfinderMob)this.mob).isUsingItem()) {
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.UNCHARGED;
                }
                if ((i = ((PathfinderMob)this.mob).getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(itemstack = ((PathfinderMob)this.mob).getUseItem()), (LivingEntity)this.mob)) {
                    ((PathfinderMob)this.mob).releaseUsingItem();
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.CHARGED;
                    this.attackDelay = 20 + ((PathfinderMob)this.mob).getRandom().nextInt(20);
                    ((CrossbowAttackMob)((PathfinderMob)this.mob)).setChargingCrossbow(false);
                }
            } else if (this.crossbowState == RangedCrossbowAttackGoal.CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == RangedCrossbowAttackGoal.CrossbowState.READY_TO_ATTACK && flag) {
                ((RangedAttackMob)((PathfinderMob)this.mob)).performRangedAttack(livingentity, 1.0f);
                ItemStack itemInHand = ((PathfinderMob)this.mob).getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, IVampirismCrossbow.class::isInstance));
                ChargedProjectiles projectiles = (ChargedProjectiles)itemInHand.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
                if (!projectiles.isEmpty()) {
                    int delay = this.getAttackDelay(itemInHand);
                    this.attackDelay = delay + ((PathfinderMob)this.mob).getRandom().nextInt(delay);
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.CHARGED;
                } else {
                    itemInHand.remove(DataComponents.CHARGED_PROJECTILES);
                    this.crossbowState = RangedCrossbowAttackGoal.CrossbowState.UNCHARGED;
                }
            }
        }
    }

    private int getAttackDelay(ItemStack stack) {
        return stack.getItem() instanceof TechCrossbowItem ? 10 : 20;
    }
}

