/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.entity.IEntityFollower;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class FindLeaderGoal<T extends Mob, Z extends LivingEntity>
extends Goal {
    private final T entity;
    protected TargetingConditions targetConditions;
    private Z leader;
    protected final int randomInterval = FindLeaderGoal.reducedTickDelay((int)10);

    public FindLeaderGoal(T entity, Predicate<Z> leaderPredicate) {
        this.entity = entity;
        this.targetConditions = TargetingConditions.forNonCombat().ignoreLineOfSight().range(this.getFollowDistance()).selector(leaderPredicate);
    }

    protected double getFollowDistance() {
        return this.entity.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    public boolean canUse() {
        if (((IEntityFollower)this.entity).getLeader() != null && ((IEntityFollower)this.entity).getLeader().isAlive() || this.randomInterval > 0 && this.entity.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findLeader();
        return this.leader != null;
    }

    public void start() {
        ((IEntityFollower)this.entity).setLeader(this.leader);
        super.start();
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.entity.getBoundingBox().inflate(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findLeader() {
        this.leader = this.entity.level().getNearestEntity(this.entity.level().getEntitiesOfClass(LivingEntity.class, this.getTargetSearchArea(this.getFollowDistance()), IEntityLeader.class::isInstance), this.targetConditions, this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ());
    }
}

