/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.RemainsDefenderEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VulnerableRemainsDummyEntity
extends LivingEntity
implements IEntityLeader,
IRemainsEntity {
    private BlockPos ownerPos = null;
    private Object2IntMap<Direction> delayRespawn = new Object2IntOpenHashMap();
    private int followerCount = 0;

    public VulnerableRemainsDummyEntity(EntityType<VulnerableRemainsDummyEntity> type, Level pLevel) {
        super(type, pLevel);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes();
    }

    public float getHealth() {
        return this.getTile().map(VulnerableRemainsBlockEntity::getHealth).orElse(1).intValue();
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    public void setDeltaMovement(@NotNull Vec3 pMotion) {
    }

    protected void actuallyHurt(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        this.getTile().ifPresent(vr -> vr.onDamageDealt(pDamageSource, pDamageAmount));
        Entity entity = pDamageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            attacker.hurt(this.damageSources().thorns((Entity)this), 3.0f);
        }
    }

    public void childrenIsHurt(DamageSource damageSource, boolean killed, Direction direction) {
        this.getTile().ifPresent(vr -> vr.onDamageDealt(damageSource, 0.0));
        if (killed) {
            this.delayRespawn.put((Object)direction, 100);
        }
    }

    public boolean isInvulnerableTo(@NotNull DamageSource pSource) {
        return this.isRemoved() || pSource.is(ModTags.DamageTypes.MOTHER_RESISTANT_TO);
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot pSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    public boolean isPickable() {
        return true;
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }

    public void push(@NotNull Entity pEntity) {
    }

    public void setOwnerLocation(BlockPos pos) {
        this.ownerPos = pos;
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        if (!this.level().isClientSide) {
            BlockState block = this.level().getBlockState(this.ownerPos);
            if (this.ownerPos == null || !block.is((Block)ModBlocks.ACTIVE_VULNERABLE_REMAINS.get()) || block.is((Block)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get())) {
                if (block.is((Block)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get())) {
                    this.getPassengers().forEach(s -> s.setRemoved(Entity.RemovalReason.DISCARDED));
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (this.level().getGameTime() % 400L == 16L) {
                this.spawnDefender();
            }
        }
    }

    public void spawnDefender() {
        BlockPos pos = this.ownerPos;
        List<Direction> directionStream = Arrays.stream(Direction.values()).filter(direction -> this.delayRespawn.getOrDefault(direction, 0) <= 0).filter(l -> {
            boolean block = this.level().getBlockState(pos.relative(l)).canBeReplaced();
            return block && !this.hasDefender((Direction)l);
        }).toList();
        if (!directionStream.isEmpty()) {
            this.spawnDefender(directionStream.get(this.random.nextInt(directionStream.size())));
        }
    }

    public void spawnDefenders() {
        this.delayRespawn.clear();
        BlockPos pos = this.ownerPos;
        Arrays.stream(Direction.values()).filter(l -> {
            boolean block = this.level().getBlockState(pos.relative(l)).canBeReplaced();
            return block && !this.hasDefender((Direction)l);
        }).forEach(this::spawnDefender);
    }

    private boolean hasDefender(Direction direction) {
        return this.getPassengers().stream().anyMatch(entity -> {
            RemainsDefenderEntity defender;
            return entity instanceof RemainsDefenderEntity && (defender = (RemainsDefenderEntity)entity).getAttachFace().getOpposite() == direction;
        });
    }

    public void spawnDefender(Direction direction) {
        RemainsDefenderEntity defender = (RemainsDefenderEntity)((EntityType)ModEntities.REMAINS_DEFENDER.get()).create(this.level());
        this.getTile().map(BlockEntity::getBlockPos).ifPresent(pos -> {
            defender.setPos(Vec3.atBottomCenterOf((Vec3i)pos.relative(direction)));
            defender.setAttachFace(direction.getOpposite());
            this.level().addFreshEntity((Entity)defender);
            defender.startRiding((Entity)this);
            defender.setYRot(0.0f);
            defender.yHeadRot = this.getYRot();
            defender.setOldPosAndRot();
        });
    }

    protected boolean canAddPassenger(Entity pPassenger) {
        return pPassenger instanceof RemainsDefenderEntity && this.getPassengers().size() < 6;
    }

    public Optional<VulnerableRemainsBlockEntity> getTile() {
        BlockEntity blockEntity;
        if (this.ownerPos != null && this.level().isLoaded(this.ownerPos) && (blockEntity = this.level().getBlockEntity(this.ownerPos)) instanceof VulnerableRemainsBlockEntity) {
            VulnerableRemainsBlockEntity vr = (VulnerableRemainsBlockEntity)blockEntity;
            return Optional.of(vr);
        }
        return Optional.empty();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        pCompound.putIntArray("ownerPos", new int[]{this.ownerPos.getX(), this.ownerPos.getY(), this.ownerPos.getZ()});
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        int[] pos = pCompound.getIntArray("ownerPos");
        this.ownerPos = new BlockPos(pos[0], pos[1], pos[2]);
    }

    @Override
    public void decreaseFollowerCount() {
        --this.followerCount;
    }

    @Override
    public int getFollowingCount() {
        return this.followerCount;
    }

    @Override
    public int getMaxFollowerCount() {
        return this.isAlive() ? Integer.MAX_VALUE : 0;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public boolean increaseFollowerCount() {
        ++this.followerCount;
        return true;
    }

    @Nullable
    public SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.REMAINS_DEATH.get();
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.REMAINS_HURT.get();
    }
}

