/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import com.google.common.base.Preconditions;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.Set;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import org.jetbrains.annotations.NotNull;

public class SanguinareEffect
extends VampirismEffect {
    public static void addRandom(@NotNull LivingEntity entity, boolean player) {
        SanguinareEffect.addRandom(entity, player, false);
    }

    public static void addRandom(@NotNull LivingEntity entity, boolean player, boolean fasterInfection) {
        int avgDuration = 20 * (player ? (Integer)VampirismConfig.BALANCE.vpSanguinareAverageDuration.get() : BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        if (fasterInfection) {
            avgDuration /= 2;
        }
        int duration = (int)((entity.getRandom().nextFloat() + 0.5f) * (float)avgDuration);
        SanguinareEffectInstance effect = new SanguinareEffectInstance(duration);
        Preconditions.checkNotNull((Object)((Object)effect));
        if (!((Boolean)VampirismConfig.BALANCE.canCancelSanguinare.get()).booleanValue()) {
            effect.getCures().clear();
        }
        entity.addEffect((MobEffectInstance)effect);
    }

    public SanguinareEffect(@NotNull MobEffectCategory effectType, int potionColor) {
        super(effectType, potionColor);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ModEffects.SANGUINARE.getId(), 2.0, AttributeModifier.Operation.ADD_VALUE);
    }

    @Override
    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        super.fillEffectCures(cures, effectInstance);
        cures.add(ModItems.GARLIC_CURE);
    }

    @Override
    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        if (entity.level().isClientSide || !entity.isAlive()) {
            return true;
        }
        if (entity instanceof PathfinderMob) {
            ExtendedCreature.getSafe((Entity)entity).ifPresent(IExtendedCreatureVampirism::makeVampire);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            VampirePlayer.get(player).onSanguinareFinished();
        }
        return false;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 2;
    }
}

