/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.reloadlistener;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.util.MixinHooks;
import io.netty.handler.codec.DecoderException;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SingleJigsawReloadListener
implements PreparableReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String directory = "vampirism";
    private static final String fileName = "single_jigsaw_pieces.json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    public static final Codec<List<ResourceLocation>> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.listOf().fieldOf("single_pieces").forGetter(list -> list)).apply((Applicative)inst, a -> a));

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier pPreparationBarrier, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pPreparationsProfiler, @NotNull ProfilerFiller pReloadProfiler, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
        return ((CompletableFuture)this.prepare(pResourceManager, pBackgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pPreparationBarrier).wait(arg_0))).thenAcceptAsync(MixinHooks::replaceSingleInstanceStructure);
    }

    @NotNull
    public CompletableFuture<List<ResourceLocation>> prepare(@NotNull ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.load(manager), executor);
    }

    @NotNull
    public List<ResourceLocation> load(ResourceManager manager) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (Map.Entry entry : manager.listResourceStacks(directory, location -> location.getPath().endsWith(fileName)).entrySet()) {
            ResourceLocation resourceName = VResourceLocation.loc(((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath().substring(directory.length() + 1, ((ResourceLocation)entry.getKey()).getPath().length() - PATH_SUFFIX_LENGTH));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        List newLocations = (List)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(DecoderException::new);
                        locations.addAll(newLocations);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not read single jigsaw pieces file {} from {}", (Object)resourceName, (Object)resource.sourcePackId(), (Object)e);
                }
            }
        }
        return locations;
    }
}

