/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.provider.parent;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeConfiguration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class SkillTreeProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final String modId;

    public SkillTreeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "vampirism/configured_skill_tree");
        this.lookupProvider = lookupProvider;
        this.modId = modId;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        return this.lookupProvider.thenCompose(provider -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
            this.buildSkillTrees((HolderLookup.Provider)provider, (id, skillTree) -> {
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate skill tree " + String.valueOf(id));
                }
                list.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)provider, SkillTreeConfiguration.CODEC, (Object)skillTree, (Path)this.pathProvider.json(id)));
                return id;
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void buildSkillTrees(HolderLookup.Provider var1, @NotNull SkillTreeOutput var2);

    @NotNull
    public String getName() {
        return "Skill tree config";
    }

    @NotNull
    protected ResourceLocation modId(@NotNull String string) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)string);
    }

    public static interface SkillTreeOutput {
        public ResourceLocation accept(ResourceLocation var1, SkillTreeConfiguration var2);
    }
}

