/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.BalanceConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class BalanceBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final Map<String, Map<String, Conf>> categoryConfigMap;
    @NotNull
    private final Map<String, String> categoryPrefixMap;
    private final ConcurrentHashMap<String, Consumer<? extends Conf>> balanceModifications = new ConcurrentHashMap();
    private Map<String, Conf> activeCategory;
    @Nullable
    private String currentComment;

    private static void setVal(BalanceConfig conf, @NotNull String name, Object value) {
        try {
            Field f = BalanceConfig.class.getDeclaredField(name);
            f.setAccessible(true);
            f.set(conf, value);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to set Balance value as expected", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access when trying to set Balance value as expected", (Throwable)e);
        }
    }

    BalanceBuilder() {
        this.categoryConfigMap = new HashMap<String, Map<String, Conf>>();
        this.categoryPrefixMap = new HashMap<String, String>();
    }

    public void addBalanceModifier(@NotNull String key, @NotNull Consumer<? extends Conf> modifier) {
        if (this.balanceModifications.put(key, modifier) != null && VampirismMod.inDev) {
            LOGGER.warn("Overriding existing config modifier for {}", (Object)key);
        }
    }

    public void build(BalanceConfig conf, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModConfigSpec.Builder builder) {
        if (!this.balanceModifications.isEmpty()) {
            LOGGER.info("Building balance configuration with {} modifications", (Object)this.balanceModifications.size());
        }
        for (Map.Entry<String, Map<String, Conf>> stringMapEntry : this.categoryConfigMap.entrySet()) {
            String category = stringMapEntry.getKey();
            String catPrefix = this.categoryPrefixMap.getOrDefault(category, category);
            builder.push(category);
            for (Map.Entry<String, Conf> stringConfEntry : stringMapEntry.getValue().entrySet()) {
                String name = stringConfEntry.getKey();
                Object fullName = catPrefix.isEmpty() ? name : catPrefix + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                Conf c = stringConfEntry.getValue();
                Consumer<? extends Conf> modifier = this.balanceModifications.get(fullName);
                if (modifier != null) {
                    try {
                        modifier.accept(c);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to apply balance config modifier for " + (String)fullName, (Throwable)e);
                    }
                }
                ModConfigSpec.ConfigValue<?> val = c.build(builder);
                BalanceBuilder.setVal(conf, (String)fullName, val);
            }
            builder.pop();
        }
        this.categoryConfigMap.clear();
        this.balanceModifications.clear();
        this.categoryPrefixMap.clear();
        this.currentComment = null;
    }

    @NotNull
    public BalanceBuilder category(String name, String prefix) {
        this.activeCategory = new HashMap<String, Conf>();
        this.categoryConfigMap.put(name, this.activeCategory);
        this.categoryPrefixMap.put(name, prefix);
        return this;
    }

    public void checkFields(BalanceConfig config) throws IllegalStateException {
        try {
            for (Field declaredField : BalanceConfig.class.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (declaredField.get(config) != null) continue;
                throw new IllegalStateException("Config value " + declaredField.getName() + " is not set");
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access when checking balance fields", (Throwable)e);
        }
    }

    @NotNull
    public BalanceBuilder comment(String comment) {
        this.currentComment = comment;
        return this;
    }

    @NotNull
    public BalanceBuilder config(@NotNull Conf value) {
        this.activeCategory.put(value.name, value);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownNullability ModConfigSpec.BooleanValue define(String name, boolean defaultValue) {
        this.add(new BoolConf(name, defaultValue));
        return null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownNullability ModConfigSpec.IntValue defineInRange(String name, int def, int min, int max) {
        this.add(new IntConf(name, def, min, max));
        return null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownNullability ModConfigSpec.DoubleValue defineInRange(String name, double def, double min, double max) {
        this.add(new DoubleConf(name, def, min, max));
        return null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownNullability ModConfigSpec.ConfigValue<List<? extends String>> defineList(String name, @NotNull List<String> defaultValues, Supplier<String> emptyValueSupplier, Predicate<Object> validator) {
        this.add(new StringList(name, defaultValues, emptyValueSupplier, validator));
        return null;
    }

    private void add(@NotNull Conf c) {
        if (this.currentComment != null) {
            c.comment(this.currentComment);
            this.currentComment = null;
        }
        this.activeCategory.put(c.name, c);
    }

    public static abstract class Conf {
        protected final String name;
        @Nullable
        private String comment = null;

        protected Conf(String name) {
            this.name = name;
        }

        public final ModConfigSpec.ConfigValue<?> build(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModConfigSpec.Builder builder) {
            if (this.comment != null) {
                builder.comment(this.comment);
            }
            return this.buildInternal(builder);
        }

        public void comment(String comment) {
            this.comment = comment;
        }

        @Nullable
        public String getComment() {
            return this.comment;
        }

        protected abstract ModConfigSpec.ConfigValue<?> buildInternal(ModConfigSpec.Builder var1);
    }

    public static class BoolConf
    extends Conf {
        private boolean defaultValue;

        protected BoolConf(String name, boolean defaultValue) {
            super(name);
            this.defaultValue = defaultValue;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected ModConfigSpec.ConfigValue<?> buildInternal(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModConfigSpec.Builder builder) {
            return builder.define(this.name, this.defaultValue);
        }
    }

    public static class IntConf
    extends Conf {
        private final int minValue;
        private final int maxValue;
        private int defaultValue;

        IntConf(String name, int defaultValue, int minValue, int maxValue) {
            super(name);
            this.defaultValue = defaultValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public ModConfigSpec.ConfigValue<?> buildInternal(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModConfigSpec.Builder builder) {
            return builder.defineInRange(this.name, this.defaultValue, this.minValue, this.maxValue);
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    public static class DoubleConf
    extends Conf {
        private final double min;
        private final double max;
        private double defaultValue;

        DoubleConf(String name, double defaultValue, double min, double max) {
            super(name);
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
        }

        public double getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected ModConfigSpec.ConfigValue<?> buildInternal(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModConfigSpec.Builder builder) {
            return builder.defineInRange(this.name, this.defaultValue, this.min, this.max);
        }
    }

    public static class StringList
    extends Conf {
        @NotNull
        private final List<String> defaultValue;
        private final Predicate<Object> elementValidator;
        private final Supplier<String> emptyValueSupplier;

        StringList(String name, @NotNull List<String> defaultValue, Supplier<String> emptyValueSupplier, Predicate<Object> validator) {
            super(name);
            this.defaultValue = new ArrayList<String>(defaultValue);
            this.elementValidator = validator;
            this.emptyValueSupplier = emptyValueSupplier;
        }

        public void addValue(String s) {
            if (this.elementValidator.test(s)) {
                this.defaultValue.add(s);
            }
        }

        @Override
        public ModConfigSpec.ConfigValue<?> buildInternal(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModConfigSpec.Builder builder) {
            return builder.defineList(this.name, Collections.unmodifiableList(this.defaultValue), this.emptyValueSupplier, this.elementValidator);
        }

        public void removeValue(String s) {
            this.defaultValue.remove(s);
        }
    }
}

