/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.MinionArgument;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class MinionInventoryCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.minion_inventory.no_player"));
    private static final SimpleCommandExceptionType NO_MINION = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.minion_inventory.no_minion"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext builderContext) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"modifyMinionInventory").requires(context -> context.hasPermission(3))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"minion", (ArgumentType)MinionArgument.minions()).then(Commands.literal((String)"list").executes(context -> MinionInventoryCommand.listInventory((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"))))).then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)builderContext)).executes(context -> MinionInventoryCommand.removeItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.getItem((CommandContext)context, (String)"item"), 1))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.removeItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.getItem((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))).then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)builderContext)).executes(context -> MinionInventoryCommand.addItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.getItem((CommandContext)context, (String)"item"), 1))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.addItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.getItem((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))));
    }

    private static int addItem(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack itemStack = item.createItemStack(count, true);
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            minionInventory.addItemStack(itemStack.copy());
            VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} added {} {} to inventory of {}", player.getName().getString(), itemStack.getCount(), itemStack.getDisplayName().getString(), playerMinionIdentifier);
            source.sendSystemMessage((Component)Component.translatable((String)"command.vampirism.base.minion_inventory.add_success", (Object[])new Object[]{itemStack.getCount(), itemStack.getDisplayName().getString(), playerMinionIdentifier}).withStyle(ChatFormatting.AQUA));
        });
        return 0;
    }

    private static int removeItem(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack itemStack = item.createItemStack(1, false);
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            List<ItemStack> itemStacks = minionInventory.getAllInventorys().stream().flatMap(Collection::stream).filter(s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)itemStack)).toList();
            if (!itemStacks.isEmpty()) {
                ItemStack stack = itemStacks.getFirst().split(count);
                player.addItem(stack.copy());
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} removed {} {} from inventory of {}", player.getName().getString(), stack.getCount(), stack.getDisplayName().getString(), playerMinionIdentifier);
                source.sendSuccess(() -> Component.translatable((String)"command.vampirism.base.minion_inventory.item_removed", (Object[])new Object[]{stack.getCount(), stack.getDisplayName().getString(), playerMinionIdentifier}).withStyle(ChatFormatting.AQUA), false);
            } else {
                source.sendFailure((Component)Component.translatable((String)"command.vampirism.base.minion_inventory.item_not_found"));
            }
        });
        return 0;
    }

    private static int listInventory(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(inv -> {
            HashMap count = new HashMap();
            inv.getAllInventorys().stream().flatMap(Collection::stream).filter(stack -> !stack.isEmpty()).forEach(item -> count.merge(item.getItem(), item.getCount(), Integer::sum));
            if (count.isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"command.vampirism.base.minion_inventory.empty", (Object[])new Object[]{playerMinionIdentifier}).withStyle(ChatFormatting.AQUA), false);
            } else {
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} views inventory of {}", player.getName().getString(), playerMinionIdentifier);
                source.sendSuccess(() -> Component.translatable((String)"command.vampirism.base.minion_inventory.content", (Object[])new Object[]{playerMinionIdentifier}).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), false);
                source.sendSuccess(() -> Component.literal((String)count.entrySet().stream().map(a -> String.valueOf(a.getValue()) + " " + String.valueOf(RegUtil.id((Item)a.getKey()))).collect(Collectors.joining("\n"))).withStyle(ChatFormatting.AQUA), false);
            }
        });
        return 0;
    }

    private static Optional<MinionInventory> getInventory(MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        String playerName = playerMinionIdentifier.player;
        int minionId = playerMinionIdentifier.id;
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        GameProfile profile = (GameProfile)ServerLifecycleHooks.getCurrentServer().getProfileCache().get(playerName).orElseThrow(() -> ((SimpleCommandExceptionType)NO_PLAYER).create());
        PlayerMinionController controller = data.getController(profile.getId());
        if (controller == null) {
            throw NO_MINION.create();
        }
        Optional<MinionInventory> minionInventory = controller.contactMinionData(minionId, minionData -> {
            playerMinionIdentifier.updateName(minionData.getFormattedName().getString());
            return minionData.getInventory();
        });
        if (minionInventory.isEmpty()) {
            throw NO_MINION.create();
        }
        return minionInventory;
    }
}

