/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.BiomeArgument;
import de.teamlapen.vampirism.command.arguments.ModSuggestionProvider;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ConfigCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_SELECTED_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.bloodvalues.blacklist.no_entity"));
    private static final SimpleCommandExceptionType NO_CONFIG_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.no_config"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.bloodvalues.no_type"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.bloodvalues.blacklist.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.sun_damage.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.config.sun_damage.blacklist.no_type"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").requires(context -> context.hasPermission(3))).executes(context -> {
            throw NO_CONFIG_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"bloodvalues").executes(context -> {
            throw NO_BLOOD_VALUE_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"blacklist").executes(context -> {
            throw NO_BLOOD_VALUE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"entity").executes(context -> ConfigCommand.blacklistEntity(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).suggests(ModSuggestionProvider.ENTITIES).executes(context -> ConfigCommand.blacklistEntity(((CommandSourceStack)context.getSource()).getPlayerOrException(), ResourceArgument.getEntityType((CommandContext)context, (String)"entity").key().location()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sundamage").executes(context -> {
            throw NO_SUN_DAMAGE_TYPE.create();
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blacklist").executes(context -> {
            throw NO_SUN_DAMAGE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"biome").executes(context -> ConfigCommand.blacklistBiome(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"biome", (ArgumentType)BiomeArgument.biome()).suggests(ModSuggestionProvider.BIOMES).executes(context -> ConfigCommand.blacklistBiome(((CommandSourceStack)context.getSource()).getPlayerOrException(), BiomeArgument.getBiome((CommandContext<CommandSourceStack>)context, "biome").key().location()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"dimension").executes(context -> ConfigCommand.blacklistDimension(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> ConfigCommand.blacklistDimension(((CommandSourceStack)context.getSource()).getPlayerOrException(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"))))))).then(Commands.literal((String)"enforce").then(((LiteralArgumentBuilder)Commands.literal((String)"dimension").executes(context -> ConfigCommand.enforceDimension(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> ConfigCommand.enforceDimension(((CommandSourceStack)context.getSource()).getPlayerOrException(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))))))).then(Commands.literal((String)"bat-dimension-blacklist").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> ConfigCommand.batBlacklistDimension(((CommandSourceStack)context.getSource()).getPlayerOrException(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))));
    }

    private static int blacklistEntity(@NotNull ServerPlayer player) throws CommandSyntaxException {
        Vec3 vec3d = player.getEyePosition(1.0f);
        double d0 = 50.0;
        Vec3 vec3d1 = player.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * d0, vec3d1.y * d0, vec3d1.z * d0);
        AABB axisalignedbb = player.getBoundingBox().expandTowards(vec3d1.scale(d0)).inflate(1.0);
        EntityHitResult result = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)vec3d, (Vec3)vec3d2, (AABB)axisalignedbb, a -> !a.isSpectator());
        if (result == null) {
            throw NO_SELECTED_ENTITY.create();
        }
        Entity entity = result.getEntity();
        EntityType entityType = entity.getType();
        return ConfigCommand.blacklistEntity(player, RegUtil.id(entityType));
    }

    private static int blacklistEntity(@NotNull ServerPlayer player, @NotNull ResourceLocation entity) {
        return ConfigCommand.modifyList(player, entity, VampirismConfig.SERVER.blacklistedBloodEntity, "command.vampirism.base.config.entity.blacklisted", "command.vampirism.base.config.entity.not_blacklisted");
    }

    private static int blacklistBiome(@NotNull ServerPlayer player) {
        return ConfigCommand.blacklistBiome(player, (ResourceLocation)player.getCommandSenderWorld().getBiome(player.blockPosition()).unwrap().map(ResourceKey::location, biome -> RegUtil.id(player.getCommandSenderWorld(), biome)));
    }

    private static int blacklistBiome(@NotNull ServerPlayer player, @NotNull ResourceLocation biome) {
        return ConfigCommand.modifyList(player, biome, VampirismConfig.SERVER.sundamageDisabledBiomes, "command.vampirism.base.config.biome.blacklisted", "command.vampirism.base.config.biome.not_blacklisted");
    }

    private static int blacklistDimension(@NotNull ServerPlayer player) {
        return ConfigCommand.blacklistDimension(player, player.serverLevel());
    }

    private static int blacklistDimension(@NotNull ServerPlayer player, @NotNull ServerLevel dimension) {
        return ConfigCommand.modifyList(player, dimension.dimension().location(), VampirismConfig.SERVER.sundamageDimensionsOverrideNegative, "command.vampirism.base.config.dimension.blacklisted", "command.vampirism.base.config.dimension.not_blacklisted");
    }

    private static int enforceDimension(@NotNull ServerPlayer player) {
        return ConfigCommand.enforceDimension(player, player.serverLevel());
    }

    private static int enforceDimension(@NotNull ServerPlayer player, @NotNull ServerLevel dimension) {
        return ConfigCommand.modifyList(player, dimension.dimension().location(), VampirismConfig.SERVER.sundamageDimensionsOverridePositive, "command.vampirism.base.config.dimension.enforced", "command.vampirism.base.config.dimension.not_enforced");
    }

    private static int batBlacklistDimension(@NotNull ServerPlayer player, @NotNull ServerLevel dim) {
        return ConfigCommand.modifyList(player, dim.dimension().location(), VampirismConfig.SERVER.batDimensionBlacklist, "command.vampirism.base.config.bat_dim.blacklisted", "command.vampirism.base.config.bat_dim.not_blacklisted");
    }

    private static int modifyList(@NotNull ServerPlayer player, @NotNull ResourceLocation id, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModConfigSpec.ConfigValue<List<? extends String>> configList, @NotNull String blacklist, @NotNull String not_blacklist) {
        List list = (List)configList.get();
        if (!list.contains(id.toString())) {
            list.add(id.toString());
            player.displayClientMessage((Component)Component.translatable((String)blacklist, (Object[])new Object[]{id}), false);
        } else {
            list.remove(id.toString());
            player.displayClientMessage((Component)Component.translatable((String)not_blacklist, (Object[])new Object[]{id}), false);
        }
        configList.set((Object)list);
        return 0;
    }
}

