/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.BaronAttireModel;
import de.teamlapen.vampirism.client.model.BaronWrapperModel;
import de.teamlapen.vampirism.client.model.BaronessAttireModel;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class BaronAttireLayer
extends RenderLayer<VampireBaronEntity, BaronWrapperModel> {
    @NotNull
    private final BaronessAttireModel baroness;
    @NotNull
    private final BaronAttireModel baron;
    private final ResourceLocation textureBaroness = VResourceLocation.mod("textures/entity/baroness_attire.png");
    private final ResourceLocation textureBaron = VResourceLocation.mod("textures/entity/baron_attire.png");
    private final Predicate<VampireBaronEntity> predicateFemale;

    public BaronAttireLayer(@NotNull RenderLayerParent<VampireBaronEntity, BaronWrapperModel> entityRendererIn, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context, Predicate<VampireBaronEntity> predicateFemale) {
        super(entityRendererIn);
        this.baroness = new BaronessAttireModel(context.bakeLayer(ModEntitiesRender.BARONESS_ATTIRE));
        this.baron = new BaronAttireModel(context.bakeLayer(ModEntitiesRender.BARON_ATTIRE));
        this.predicateFemale = predicateFemale;
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entityIn.isInvisible()) {
            boolean female = this.predicateFemale.test(entityIn);
            EntityModel model = female ? this.baroness : this.baron;
            BaronAttireLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), (EntityModel)model, (ResourceLocation)(female ? this.textureBaroness : this.textureBaron), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)-1);
        }
    }
}

