/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.RemainsDefenderModel;
import de.teamlapen.vampirism.entity.RemainsDefenderEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RemainsDefenderRenderer
extends MobRenderer<RemainsDefenderEntity, RemainsDefenderModel> {
    private final ResourceLocation TEX1 = VResourceLocation.mod("textures/entity/remains_defender/remains_defender1.png");
    private final ResourceLocation TEX2 = VResourceLocation.mod("textures/entity/remains_defender/remains_defender2.png");
    private final ResourceLocation TEX3 = VResourceLocation.mod("textures/entity/remains_defender/remains_defender3.png");
    private final ResourceLocation TEX4 = VResourceLocation.mod("textures/entity/remains_defender/remains_defender4.png");

    public RemainsDefenderRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new RemainsDefenderModel(pContext.bakeLayer(ModEntitiesRender.REMAINS_DEFENDER)), 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull RemainsDefenderEntity pEntity) {
        int t = pEntity.tickCount % 20;
        if (t > 15) {
            return this.TEX4;
        }
        if (t > 10) {
            return this.TEX3;
        }
        if (t > 5) {
            return this.TEX2;
        }
        return this.TEX1;
    }

    protected void setupRotations(RemainsDefenderEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float scale) {
        pMatrixStack.translate(0.0, 0.5, 0.0);
        pMatrixStack.mulPose(pEntityLiving.getAttachFace().getOpposite().getRotation());
        pMatrixStack.translate(0.0, -0.5, 0.0);
    }

    protected int getBlockLightLevel(RemainsDefenderEntity pEntity, BlockPos pPos) {
        int i = (int)Mth.clampedLerp((float)0.0f, (float)15.0f, (float)((float)pEntity.getLightTicksRemaining() / 10.0f));
        return i == 15 ? 15 : Math.max(i, super.getBlockLightLevel((Entity)pEntity, pPos));
    }
}

