/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blockentity.BatCageBlockEntity;
import de.teamlapen.vampirism.blocks.BatCageBlock;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BatCageBESR
extends VampirismBESR<BatCageBlockEntity> {
    private final BatModel model;
    private Bat bat;

    public BatCageBESR(BlockEntityRendererProvider.Context context) {
        this.model = new BatModel(context.bakeLayer(ModelLayers.BAT));
    }

    public void render(BatCageBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = pBlockEntity.getBlockState();
        if (((Boolean)blockState.getValue((Property)BatCageBlock.CONTAINS_BAT)).booleanValue()) {
            this.checkBat(pBlockEntity.getLevel());
            this.renderBat(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, (Direction)blockState.getValue((Property)BatCageBlock.FACING), pBlockEntity.getLevel(), pPartialTick);
        }
    }

    private void checkBat(Level pLevel) {
        if (this.bat == null) {
            this.bat = (Bat)EntityType.BAT.create(pLevel);
            this.bat.flyAnimationState.stop();
            this.bat.restAnimationState.startIfStopped(this.bat.hashCode());
        }
    }

    private void renderBat(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, Direction direction, Level level, float pPartialTick) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 1.0f, 0.5f);
        pPoseStack.mulPose(Axis.YN.rotationDegrees((float)(90 * direction.get2DDataValue())));
        pPoseStack.scale(0.65f, 0.65f, 0.65f);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.model.setupAnim(this.bat, 0.0f, 0.0f, (float)level.getGameTime() + pPartialTick + (float)this.bat.hashCode(), -1.0f, -1.0f);
        this.model.renderToBuffer(pPoseStack, pBuffer.getBuffer(this.model.renderType(VResourceLocation.mc("textures/entity/bat.png"))), pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
    }
}

