/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class BaronessAttireModel
extends EntityModel<VampireBaronEntity> {
    private static final String VEIL = "veil";
    private static final String DRESS_ARM_LEFT = "dress_arm_left";
    private static final String DRESS_ARM_RIGHT = "dress_arm_right";
    private static final String DRESS_CURTAIN = "dress_curtain";
    private static final String HOOD = "hood";
    private static final String HAT = "hat";
    private static final String HAT2 = "hat2";
    private static final String DRESS_TORSO = "dress_torso";
    private static final String CLOAK = "cloak";
    @NotNull
    public final ModelPart dressTorso;
    @NotNull
    public final ModelPart dressArmBandRight;
    @NotNull
    public final ModelPart dressArmBandLeft;
    @NotNull
    public final ModelPart hat;
    @NotNull
    public final ModelPart hood;
    @NotNull
    public final ModelPart dressCurtain;
    @NotNull
    public final ModelPart hat2;
    @NotNull
    public final ModelPart veil;
    @NotNull
    public final ModelPart cloak;
    private float enragedProgress = 0.0f;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition hat = part.addOrReplaceChild(HAT, CubeListBuilder.create().texOffs(68, 36).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.ZERO);
        PartDefinition hood = part.addOrReplaceChild(HOOD, CubeListBuilder.create().texOffs(44, 0).addBox(-4.5f, -8.5f, -4.0f, 9.0f, 9.0f, 9.0f), PartPose.ZERO);
        PartDefinition dressTorso = part.addOrReplaceChild(DRESS_TORSO, CubeListBuilder.create().texOffs(72, 30).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.ZERO);
        hat.addOrReplaceChild(VEIL, CubeListBuilder.create().texOffs(32, 28).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.ZERO);
        part.addOrReplaceChild(DRESS_ARM_LEFT, CubeListBuilder.create().texOffs(60, 46).addBox(0.0f, 2.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        dressTorso.addOrReplaceChild(DRESS_CURTAIN, CubeListBuilder.create().texOffs(64, 43).addBox(-6.0f, 0.0f, -4.0f, 12.0f, 11.0f, 10.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        hat.addOrReplaceChild(HAT2, CubeListBuilder.create().texOffs(72, 30).addBox(-2.0f, -11.0f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.ZERO);
        hood.addOrReplaceChild(CLOAK, CubeListBuilder.create().texOffs(0, 0).addBox(-8.5f, -1.0f, -2.5f, 17.0f, 22.0f, 5.0f), PartPose.rotation((float)0.31415927f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(DRESS_ARM_RIGHT, CubeListBuilder.create().texOffs(60, 46).addBox(-3.0f, 2.0f, -2.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public BaronessAttireModel(@NotNull ModelPart part) {
        this.dressTorso = part.getChild(DRESS_TORSO);
        this.dressArmBandLeft = part.getChild(DRESS_ARM_LEFT);
        this.dressArmBandRight = part.getChild(DRESS_ARM_RIGHT);
        this.hat = part.getChild(HAT);
        this.hood = part.getChild(HOOD);
        this.dressCurtain = this.dressTorso.getChild(DRESS_CURTAIN);
        this.hat2 = this.hat.getChild(HAT2);
        this.veil = this.hat.getChild(VEIL);
        this.cloak = this.hood.getChild(CLOAK);
    }

    public void prepareMobModel(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.enragedProgress = entityIn.getEnragedProgress();
    }

    public void renderToBuffer(@NotNull PoseStack matrixStackIn, @NotNull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.dressArmBandLeft.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.dressArmBandRight.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.dressTorso.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.hat.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        matrixStackIn.pushPose();
        matrixStackIn.scale(1.0f - 0.5f * this.enragedProgress, 1.0f - 0.7f * this.enragedProgress, 1.0f - 0.5f * this.enragedProgress);
        this.hood.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        matrixStackIn.popPose();
    }

    public void setRotateAngle(@NotNull ModelPart renderer, float x, float y, float z) {
        renderer.xRot = x;
        renderer.yRot = y;
        renderer.zRot = z;
    }

    public void setupAnim(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyRotateY = 0.0f;
        float headRotateY = 0.0f;
        headRotateY = netHeadYaw * ((float)Math.PI / 180);
        if (this.attackTime > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            float f1 = this.attackTime;
            bodyRotateY = Mth.sin((float)(Mth.sqrt((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                bodyRotateY *= -1.0f;
            }
        }
        this.hat.yRot = bodyRotateY + headRotateY;
        this.veil.yRot = bodyRotateY + headRotateY;
        this.hood.yRot = bodyRotateY + headRotateY;
        this.hat2.yRot = bodyRotateY + headRotateY;
        this.cloak.yRot = bodyRotateY;
        this.dressCurtain.yRot = bodyRotateY;
        this.dressTorso.yRot = bodyRotateY;
        this.dressArmBandLeft.yRot = bodyRotateY;
        this.dressArmBandRight.yRot = bodyRotateY;
    }

    @NotNull
    protected HumanoidArm getSwingingSide(@NotNull VampireBaronEntity entity) {
        HumanoidArm handside = entity.getMainArm();
        return entity.swingingArm == InteractionHand.MAIN_HAND ? handside : handside.getOpposite();
    }
}

