/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillNodeScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.data.ClientSkillTreeData;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillsTabScreen {
    public static final int SCREEN_WIDTH = 234;
    public static final int SCREEN_HEIGHT = 173;
    private final Minecraft minecraft;
    private final SkillsScreen screen;
    private final Holder<ISkillTree> skillTree;
    private final ISkillHandler<?> skillHandler;
    private final ItemStack icon;
    private final Component title;
    private final Map<SkillTreeConfiguration.SkillTreeNodeConfiguration, SkillNodeScreen> nodes = new HashMap<SkillTreeConfiguration.SkillTreeNodeConfiguration, SkillNodeScreen>();
    private final AdvancementTabType position;
    private final SkillNodeScreen root;
    private final int treeWidth;
    private final int treeHeight;
    private final ResourceLocation background;
    private double minX = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private double maxX = Double.MAX_VALUE;
    private double maxY = Double.MIN_VALUE;
    private double zoom = 1.0;
    private final int index;
    private float fade;
    private final ClientSkillTreeData treeData;
    private double centerX;
    private double centerY;
    private final double maxZoom = 2.0;
    private final double minZoom = 0.25;

    public SkillsTabScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, int index, Holder<ISkillTree> skillTree, @NotNull ISkillHandler<?> skillHandler, ClientSkillTreeData skillTreeData) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.skillTree = skillTree;
        this.skillHandler = skillHandler;
        ISkillTree tree = (ISkillTree)skillTree.value();
        this.index = index;
        this.icon = tree.display();
        this.title = tree.name();
        this.position = AdvancementTabType.LEFT;
        this.treeData = skillTreeData;
        this.treeWidth = this.treeData.getTreeWidth(skillTree);
        this.treeHeight = this.treeData.getTreeHeight(skillTree);
        this.root = new SkillNodeScreen(minecraft, screen, this, this.treeData.root(skillTree), this.treeData, (SkillHandler)skillHandler);
        this.background = VResourceLocation.mod("textures/gui/skills/backgrounds/level.png");
        this.addNode(this.root);
        this.recalculateBorders();
    }

    private void recalculateBorders() {
        this.minY = -(this.treeHeight + 16);
        this.maxY = 20.0;
        this.minX = -117.0;
        this.maxX = (double)this.treeWidth - 117.0;
        this.centerX = 0.0;
        this.centerY = 0.0;
    }

    private void addNode(@NotNull SkillNodeScreen screen) {
        this.nodes.put(screen.getSkillNode(), screen);
        for (SkillNodeScreen child : screen.getChildren()) {
            this.addNode(child);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void drawTab(@NotNull GuiGraphics graphics, int x, int y, boolean selected) {
        this.position.draw(graphics, x, y, selected, this.index);
    }

    public void drawIcon(GuiGraphics graphics, int x, int y) {
        this.position.drawIcon(graphics, x, y, this.index, this.icon);
    }

    public boolean isMouseOver(int guiLeft, int guiTop, double mouseX, double mouseY) {
        return this.position.isMouseOver(guiLeft, guiTop, this.index, mouseX, mouseY);
    }

    public void drawContents(@NotNull GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        graphics.enableScissor(x, y, x + 234, y + 173);
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.translate(117.0 + this.centerX, 20.0 + this.centerY, 0.0);
        pose.scale((float)this.zoom, (float)this.zoom, 1.0f);
        for (int i = -((int)((117.0 + this.centerX) / 16.0 / this.zoom)) - 1; i <= (int)((117.0 - this.centerX) / 16.0 / this.zoom); ++i) {
            for (int j = -((int)((20.0 + this.centerY) / 16.0 / this.zoom)) - 1; j <= (int)((173.0 - this.centerY) / 16.0 / this.zoom); ++j) {
                graphics.blit(this.background, 16 * i, 16 * j, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.root.drawConnectivity(graphics, 0, 0, true);
        this.root.drawConnectivity(graphics, 0, 0, false);
        this.root.draw(graphics, 0, 0);
        pose.popPose();
        if (this.minecraft.player.getEffect(ModEffects.OBLIVION) != null) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            graphics.fill(x, y, x + 234, y + 173, Mth.floor((double)127.5) << 24);
            pose.translate(0.0f, 0.0f, 200.0f);
            this.drawDisableText(graphics, x, y);
            pose.popPose();
        }
        graphics.disableScissor();
    }

    public void drawTooltips(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, -200.0f);
        graphics.fill(0, 0, 234, 173, Mth.floor((float)(this.fade * 255.0f)) << 24);
        boolean flag = false;
        if (mouseX >= 0 && mouseX < 234 && mouseY >= 0 && mouseY < 173) {
            double scaledMouseX = this.getScaledMouseX(mouseX);
            double scaledMouseY = this.getScaledMouseY(mouseY);
            for (SkillNodeScreen nodeScreen : this.nodes.values()) {
                if (!nodeScreen.isMouseOver(scaledMouseX, scaledMouseY, 0, 0)) continue;
                flag = true;
                pose.pushPose();
                pose.translate(117.0 + this.centerX, 20.0 + this.centerY, 0.0);
                pose.scale((float)this.zoom, (float)this.zoom, 1.0f);
                nodeScreen.drawHover(graphics, scaledMouseX, scaledMouseY, this.fade, 0, 0);
                pose.popPose();
                break;
            }
        }
        pose.popPose();
        this.fade = flag ? Mth.clamp((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.clamp((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    private double getScaledMouseX(double mouseX) {
        return (mouseX - 117.0 - this.centerX) / this.zoom;
    }

    private double getScaledMouseY(double mouseY) {
        return (mouseY - 20.0 - this.centerY) / this.zoom;
    }

    public void mouseDragged(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.center(this.centerX + xDragged, this.centerY + yDragged);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        double mouseX = this.getScaledMouseX(pMouseX);
        double mouseY = this.getScaledMouseY(pMouseY);
        this.zoom = Mth.clamp((double)(this.zoom + (double)((float)pScrollX * 0.1f) + (double)((float)pScrollY * 0.1f)), (double)this.minZoom, (double)this.maxZoom);
        this.center(this.centerX - (mouseX - this.getScaledMouseX(pMouseX)) * this.zoom, this.centerY - (mouseY - this.getScaledMouseY(pMouseY)) * this.zoom);
        return true;
    }

    public void center(double x, double y) {
        this.centerX = Mth.clamp((double)x, (double)(this.minX * this.zoom), (double)(this.maxX * this.zoom));
        this.centerY = Mth.clamp((double)y, (double)((double)(-this.treeHeight) * this.zoom), (double)(20.0 * this.zoom));
    }

    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public ISkill<?> getSelected(int mouseX, int mouseY) {
        for (SkillNodeScreen screen : this.nodes.values()) {
            ISkill selected = screen.getSelectedSkill(this.getScaledMouseX(mouseX), this.getScaledMouseY(mouseY), 0, 0);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public int getRemainingPoints() {
        return this.skillHandler.getLeftSkillPoints();
    }

    public void drawDisableText(@NotNull GuiGraphics graphics, int x, int y) {
        MutableComponent f = Component.translatable((String)"text.vampirism.skill.unlock_unavailable").withStyle(ChatFormatting.WHITE);
        FormattedCharSequence s = Language.getInstance().getVisualOrder((FormattedText)f);
        int tooltipTextWidth = 219;
        int tooltipX = 7 + x;
        int tooltipY = 17 + y;
        Objects.requireNonNull(this.minecraft.font);
        int tooltipHeight = 9 * 2;
        int backgroundColor = -258276348;
        int borderColorStart = 1348406284;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)tooltipX, (int)tooltipY, (int)tooltipTextWidth, (int)tooltipHeight, (int)400, (int)backgroundColor, (int)backgroundColor, (int)borderColorStart, (int)borderColorEnd);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        Font font = this.minecraft.font;
        int n = tooltipX + tooltipTextWidth / 2;
        int n2 = tooltipY + tooltipHeight / 2;
        Objects.requireNonNull(this.minecraft.font);
        graphics.drawCenteredString(font, (Component)f, n, n2 - 9 / 2, 0xF000F0);
        graphics.pose().popPose();
    }
}

