/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.client.gui.screens.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireMinionStatsScreen
extends MinionStatsScreen<VampireMinionEntity.VampireMinionData, VampireMinionEntity> {
    private final MutableComponent inventoryLevel = Component.translatable((String)"text.vampirism.minion.stats.inventory_level");
    private final MutableComponent healthLevel = Component.translatable((String)((Attribute)Attributes.MAX_HEALTH.value()).getDescriptionId());
    private final MutableComponent strengthLevel = Component.translatable((String)((Attribute)Attributes.ATTACK_DAMAGE.value()).getDescriptionId());
    private final MutableComponent speedLevel = Component.translatable((String)((Attribute)Attributes.MOVEMENT_SPEED.value()).getDescriptionId());

    public VampireMinionStatsScreen(VampireMinionEntity entity, @Nullable Screen backScreen) {
        super(entity, 4, backScreen);
    }

    @Override
    protected boolean areButtonsVisible(@NotNull VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints() > 0 || d.getLevel() < 6;
    }

    @Override
    protected int getRemainingStatPoints(@NotNull VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints();
    }

    @Override
    protected boolean isActive(@NotNull VampireMinionEntity.VampireMinionData data, int i) {
        return switch (i) {
            case 0 -> {
                if (data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (data.getRemainingStatPoints() > 0 && data.getSpeedLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void renderStats(@NotNull GuiGraphics graphics, @NotNull VampireMinionEntity.VampireMinionData data) {
        this.renderLevelRow(graphics, data.getLevel() + 1, 7);
        this.renderStatRow(graphics, 0, this.inventoryLevel, (Component)Component.literal((String)("" + data.getInventorySize())), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(graphics, 1, this.healthLevel, (Component)Component.literal((String)String.format("%.1f", ((VampireMinionEntity)this.entity).getAttribute(Attributes.MAX_HEALTH).getBaseValue())), data.getHealthLevel() + 1, 4);
        this.renderStatRow(graphics, 2, this.strengthLevel, (Component)Component.literal((String)String.format("%.1f", ((VampireMinionEntity)this.entity).getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue())), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(graphics, 3, this.speedLevel, (Component)Component.literal((String)String.format("%.1f", ((VampireMinionEntity)this.entity).getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue())), data.getSpeedLevel() + 1, 4);
    }
}

