/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.util.ItemOrdering;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.ClientConfigHelper;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen;
import de.teamlapen.vampirism.client.gui.screens.radial.edit.ReorderingGuiRadialMenu;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ServerboundActionBindingPacket;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSelectActionScreen<T extends IFactionPlayer<T>>
extends ReorderingGuiRadialMenu<IAction<?>> {
    private KeyBindingList keyBindingList;

    public static void show() {
        FactionPlayerHandler.get((Player)Minecraft.getInstance().player).getCurrentFactionPlayer().ifPresent(factionPlayer -> Minecraft.getInstance().setScreen(new EditSelectActionScreen<IFactionPlayer>((IFactionPlayer)factionPlayer)));
    }

    private static void drawActionPart(@Nullable IAction<?> action, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        if (action == null) {
            return;
        }
        graphics.blit(EditSelectActionScreen.getActionIcon(action), posX, posY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static ResourceLocation getActionIcon(IAction<?> action) {
        ResourceLocation id = RegUtil.id(action);
        return id.withPath("textures/actions/" + id.getPath() + ".png");
    }

    private static <T extends IFactionPlayer<T>> boolean isEnabled(T player, @NotNull IAction<?> item) {
        return player.getActionHandler().isActionUnlocked(item);
    }

    private static <T extends IFactionPlayer<T>> ItemOrdering<IAction<?>> getOrdering(T player) {
        return new ItemOrdering(ClientConfigHelper.getActionOrder(player.getFaction()).stream().filter(s -> s.showInSelectAction(player.asEntity())).toList(), new ArrayList(), () -> ModRegistries.ACTIONS.stream().filter(action -> action.matchesFaction((IPlayableFaction<?>)player.getFaction())).filter(s -> s.showInSelectAction(player.asEntity())).toList());
    }

    private static <T extends IFactionPlayer<T>> void saveOrdering(T player, ItemOrdering<IAction<?>> ordering) {
        ClientConfigHelper.saveActionOrder(player.getFaction().getID(), ordering.getOrdering());
    }

    public EditSelectActionScreen(T player) {
        super(EditSelectActionScreen.getOrdering(player), action -> action.getName().plainCopy(), EditSelectActionScreen::drawActionPart, ordering -> EditSelectActionScreen.saveOrdering(player, ordering), item -> EditSelectActionScreen.isEnabled(player, item));
    }

    @Override
    protected void init() {
        super.init();
        this.keyBindingList = (KeyBindingList)this.addRenderableWidget((GuiEventListener)new KeyBindingList(this.width - 140 + 4, 20, 132, this.height - 60));
        this.addRenderableWidget((GuiEventListener)new ReorderingGuiRadialMenu.ResetButton(this.width - 140 + 4, this.height - 45, 132, 20, context -> this.resetKeyBindings()));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width - 140 + 4, this.height - 24, 132, 20, (Component)Component.translatable((String)"text.vampirism.open_settings"), context -> Minecraft.getInstance().setScreen((Screen)new KeyBindsScreen((Screen)this, this.getMinecraft().options))));
    }

    private void resetKeyBindings() {
        ModKeys.ACTION_KEYS.keySet().forEach(key -> {
            FactionPlayerHandler.get((Player)this.getMinecraft().player).setBoundAction((int)key, null, false, false);
            VampirismMod.proxy.sendToServer(new ServerboundActionBindingPacket((int)key));
        });
        this.keyBindingList.clearActions();
    }

    @Override
    public void renderBackground(@NotNull GuiGraphics graphics, int p_296369_, int p_296477_, float p_294317_) {
        super.renderBackground(graphics, p_296369_, p_296477_, p_294317_);
        graphics.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        graphics.blitSprite(BACKGROUND, this.width - 140, 0, 140, this.height);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"text.vampirism.key_shortcuts"), this.width - 70, 5, -1);
    }

    public class KeyBindingList
    extends ContainerObjectSelectionList<de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen$KeyBindingList.KeyBindingSetting> {
        public KeyBindingList(int x, int y, int pWidth, int pHeight) {
            super(Minecraft.getInstance(), pWidth, pHeight, y, 20);
            this.setX(x);
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)Minecraft.getInstance().player);
            this.replaceEntries(ModKeys.ACTION_KEYS.entrySet().stream().map(pair -> new KeyBindingSetting((Integer)pair.getKey(), (KeyMapping)pair.getValue(), handler.getBoundAction((Integer)pair.getKey()))).sorted(Comparator.comparingInt(o -> o.index)).toList());
        }

        protected void renderListBackground(GuiGraphics p_331297_) {
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }

        public Optional<GuiEventListener> getChildAt(double pMouseX, double pMouseY) {
            return super.getChildAt(pMouseX, pMouseY);
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        public int getRowWidth() {
            return this.width;
        }

        public int getRowLeft() {
            return super.getRowLeft() - 2;
        }

        protected int getRowTop(int pIndex) {
            return super.getRowTop(pIndex);
        }

        public void clearActions() {
            this.children().forEach(entry -> entry.switchAction(null));
        }

        private class KeyBindingSetting
        extends ContainerObjectSelectionList.Entry<de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen$KeyBindingList.KeyBindingSetting> {
            private static final WidgetSprites REMOVE_ICON = new WidgetSprites(VResourceLocation.mod("widget/remove"), VResourceLocation.mod("widget/remove_highlighted"));
            private static final WidgetSprites BUTTON = new WidgetSprites(VResourceLocation.mc("widget/button"), VResourceLocation.mc("widget/button_highlighted"));
            private final int index;
            private final KeyMapping keyMapping;
            private IAction<?> action;
            private StringWidget stringWidget;
            private ImageWidget imageWidget;
            private ImageButton imageButton;

            public KeyBindingSetting(int index, KeyMapping keyMapping, IAction<?> action) {
                this.index = index;
                this.keyMapping = keyMapping;
                this.stringWidget = new StringWidget(0, 2, 80, 20, keyMapping.getTranslatedKeyMessage(), Minecraft.getInstance().font);
                this.imageButton = new ImageButton(115, 2, 16, 16, REMOVE_ICON, a -> this.switchAction(null));
                this.applyAction(action);
            }

            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                if (this.imageButton.mouseClicked(pMouseX - (double)KeyBindingList.this.getX(), pMouseY - (double)KeyBindingList.this.getY() - (double)((this.index - 1) * 20), pButton)) {
                    return true;
                }
                if (EditSelectActionScreen.this.movingItem != null) {
                    this.switchAction((IAction)EditSelectActionScreen.this.movingItem.get());
                    EditSelectActionScreen.this.movingItem = null;
                    EditSelectActionScreen.this.removeDummyItems();
                    return true;
                }
                return false;
            }

            private void switchAction(@Nullable IAction<?> action) {
                this.applyAction(action);
                VampirismMod.proxy.sendToServer(new ServerboundActionBindingPacket(this.index, this.action));
                FactionPlayerHandler.get((Player)Minecraft.getInstance().player).setBoundAction(this.index, this.action, false, false);
            }

            private void applyAction(@Nullable IAction<?> action) {
                this.action = action;
                if (action != null) {
                    this.imageWidget = ImageWidget.texture((int)16, (int)16, (ResourceLocation)EditSelectActionScreen.getActionIcon(action), (int)16, (int)16);
                    this.imageWidget.setPosition(90, 2);
                    this.imageButton.visible = true;
                } else {
                    this.imageWidget = ImageWidget.texture((int)16, (int)16, null, (int)16, (int)16);
                    this.imageWidget.setPosition(90, 2);
                    this.imageWidget.visible = false;
                    this.imageButton.visible = false;
                }
            }

            public List<? extends NarratableEntry> narratables() {
                return List.of(this.stringWidget, this.imageWidget, this.imageButton);
            }

            public void render(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean p_93531_, float pPartialTick) {
                pGuiGraphics.pose().pushPose();
                pGuiGraphics.pose().translate((float)pLeft, (float)pTop, 0.0f);
                this.stringWidget.render(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                this.imageWidget.render(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                this.imageButton.render(pGuiGraphics, pMouseX - pLeft, pMouseY - pTop, pPartialTick);
                pGuiGraphics.pose().popPose();
            }

            public void renderBack(@NotNull GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                if (EditSelectActionScreen.this.movingItem != null) {
                    pGuiGraphics.blitSprite(BUTTON.get(true, pIsMouseOver), pLeft, pTop, pWidth, pHeight + 5);
                }
            }

            public List<? extends GuiEventListener> children() {
                return List.of(this.stringWidget, this.imageWidget, this.imageButton);
            }
        }
    }
}

